/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ruby.rbs.common.psi.data.RbsUseClauseType;
import com.intellij.ruby.rbs.common.util.Fqn;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class RbsQualifiedNamePrefixMatcher
extends PrefixMatcher {
    @NotNull
    private final List<RbsUseClauseType> myUseClauses;
    @NotNull
    private final Fqn myContainerFqn;
    @NotNull
    private final String myQualifier;
    @NotNull
    private final PrefixMatcher myQualifierMatcher;
    @NotNull
    private final PrefixMatcher myLastComponentMatcher;
    private final boolean myIsFuzzySearch;

    RbsQualifiedNamePrefixMatcher(@NotNull List<RbsUseClauseType> useClauses, @NotNull Fqn containerFqn, @NotNull String prefix, boolean isFuzzySearch) {
        if (useClauses == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(0);
        }
        if (containerFqn == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(2);
        }
        super(prefix);
        Pair<String, String> qualifierAndName = RbsQualifiedNamePrefixMatcher.getQualifierAndName(prefix);
        this.myUseClauses = List.copyOf(useClauses);
        this.myContainerFqn = containerFqn;
        this.myQualifier = (String)qualifierAndName.first;
        this.myQualifierMatcher = new PlainPrefixMatcher(this.myQualifier, true);
        this.myLastComponentMatcher = new CamelHumpMatcher((String)qualifierAndName.second);
        this.myIsFuzzySearch = isFuzzySearch;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(3);
        }
        return new RbsQualifiedNamePrefixMatcher(this.myUseClauses, this.myContainerFqn, prefix, this.myIsFuzzySearch);
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(4);
        }
        return this.prefixMatches(element.getLookupString());
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(5);
        }
        if (this.myPrefix.contains("_") && !name.contains("_")) {
            return false;
        }
        if (!this.qualifierMatches(name)) {
            return false;
        }
        return this.myLastComponentMatcher.prefixMatches(StringUtil.strip((String)name, c -> c != ':'));
    }

    private boolean qualifierMatches(@NotNull String name) {
        if (name == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(6);
        }
        if (this.myQualifier.isEmpty() || this.myQualifier.equals("::")) {
            return this.myIsFuzzySearch || name.lastIndexOf("::") <= 0;
        }
        for (String candidate : RbsCompletionUtil.getCandidateRelativeQualifiedNames(this.myUseClauses, this.myContainerFqn, Fqn.of((String)name, (String[])new String[0]))) {
            String qualifier = (String)RbsQualifiedNamePrefixMatcher.getQualifierAndName((String)candidate).first;
            if (qualifier.isBlank() || !this.myQualifierMatcher.prefixMatches(qualifier)) continue;
            return this.myIsFuzzySearch || !StringUtil.trimStart((String)candidate, (String)this.myQualifier).contains("::");
        }
        return false;
    }

    @NotNull
    private static Pair<String, String> getQualifierAndName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(7);
        }
        if (qualifiedName.contains("::")) {
            Pair pair = Pair.pair((Object)(StringUtil.substringBeforeLast((String)qualifiedName, (String)"::") + "::"), (Object)StringUtil.substringAfterLast((String)qualifiedName, (String)"::"));
            if (pair == null) {
                RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)"", (Object)qualifiedName);
        if (pair == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useClauses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNamePrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNamePrefixMatcher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAndName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "qualifierMatches";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAndName";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

