/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionUtil;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.SequencedCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;

final class RbsQualifiedNameInsertHandler
implements InsertHandler<LookupElement> {
    static final InsertHandler<LookupElement> INSTANCE = new RbsQualifiedNameInsertHandler();

    private RbsQualifiedNameInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int tailOffset;
        int startOffset;
        String candidate;
        PsiElement element;
        RbsQualifiedNameSymbolReference reference;
        if (context == null) {
            RbsQualifiedNameInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            RbsQualifiedNameInsertHandler.$$$reportNull$$$0(1);
        }
        if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.findSymbolReferencesInElement((PsiElement)(element = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)Math.max(0, context.getTailOffset() - 1))), RbsQualifiedNameSymbolReference.class))) == null) {
            return;
        }
        Project project = context.getProject();
        GlobalSearchScope searchScope = element.getResolveScope();
        Fqn containerFqn = reference.getContainerFqn();
        Fqn fqn = Fqn.of((String)StringUtil.trimStart((String)item.getLookupString(), (String)"::"), (String[])new String[0]);
        EnumSet<RbsQualifiedNameCompletionTarget> targets = reference.getCompletionTargets();
        Iterator iterator = RbsCompletionUtil.getCandidateRelativeQualifiedNames(RbsPsiUtil.getUseClauseTypes((PsiElement)element), containerFqn, fqn).iterator();
        while (iterator.hasNext() && !(candidate = (String)iterator.next()).equals(item.getLookupString())) {
            SequencedCollection<? extends Symbol> result = RbsResolveUtil.resolveQualifiedName(project, (SearchScope)searchScope, containerFqn, candidate, targets, element);
            if (result.isEmpty() || !ContainerUtil.and(result, it -> {
                RbsQualifiedNameSymbol qualifiedNameSymbol;
                return it instanceof RbsQualifiedNameSymbol && (qualifiedNameSymbol = (RbsQualifiedNameSymbol)it).getFqn().isEquivalentTo(fqn);
            })) continue;
            int tailOffset2 = context.getCompletionChar() == '\t' ? reference.getElement().getTextRange().getEndOffset() : context.getTailOffset();
            context.getDocument().replaceString(context.getStartOffset(), tailOffset2, (CharSequence)candidate);
            context.commitDocument();
            break;
        }
        if (context.getCompletionChar() == '\t' && (startOffset = context.getTailOffset()) != (tailOffset = reference.getElement().getTextRange().getEndOffset())) {
            context.getDocument().deleteString(startOffset, tailOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNameInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

