/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ruby.rbs.completion.RbsWeighedLookupElement;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.ruby.rbs.common.RbsLanguage;
import com.intellij.ruby.rbs.common.psi.api.RbsDeclarationMembersOwner;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import com.intellij.ruby.rbs.common.util.RbsKeywords;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;

final class RbsMemberCompletionProvider
extends RubyTrackedCompletionProvider {
    static final RbsMemberCompletionProvider INSTANCE = new RbsMemberCompletionProvider();

    private RbsMemberCompletionProvider() {
        super(RbsLanguage.getInstance());
    }

    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RbsMemberCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RbsMemberCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RbsMemberCompletionProvider.$$$reportNull$$$0(2);
        }
        for (String keyword1 : RbsKeywords.INTERFACE_MEMBERS) {
            result.addElement((LookupElement)RbsWeighedLookupElement.fromKeyword(keyword1));
        }
        PsiElement position = parameters.getPosition();
        RbsDeclarationMembersOwner parentClassOrModule = RbsPsiUtil.getDirectParentClassOrModuleDeclaration((PsiElement)position);
        if (parentClassOrModule == null) {
            return;
        }
        for (String keyword : RbsKeywords.CLASS_OR_MODULE_ONLY_MEMBERS) {
            result.addElement((LookupElement)RbsWeighedLookupElement.fromKeyword(keyword));
        }
        int visibility = 0;
        HighlighterIterator iterator = parameters.getEditor().getHighlighter().createIterator(position.getTextOffset() - 1);
        while (!iterator.atEnd() && iterator.getStart() > parentClassOrModule.getTextOffset()) {
            if (iterator.getTokenType() == RbsElementTypesGenerated.RBS_KPUBLIC) {
                ++visibility;
                break;
            }
            if (iterator.getTokenType() == RbsElementTypesGenerated.RBS_KPRIVATE) {
                --visibility;
                break;
            }
            iterator.retreat();
        }
        if (visibility < 1) {
            result.addElement((LookupElement)RbsWeighedLookupElement.fromKeyword("public"));
        }
        if (visibility > -1) {
            result.addElement((LookupElement)RbsWeighedLookupElement.fromKeyword("private"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ruby/rbs/completion/RbsMemberCompletionProvider";
        objectArray[2] = "addCompletionsTracked";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

