/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.ruby.rbs.completion.RbsAbsoluteQualifiedNameInsertHandler;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameInsertHandler;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNamePrefixMatcher;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.completion.RbsCompletableSymbolService;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.usages.RbsUsageTypes;
import com.intellij.lang.ruby.rbs.ruby.project.RbsRubysigsLibraryUtil;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.psi.RbsPsiFile;
import com.intellij.ruby.rbs.common.psi.api.RbsClassAliasDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsExtendMember;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodTypeElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleAliasDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsQualifiedNameDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsSuperClassElement;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeDeclarationElement;
import com.intellij.ruby.rbs.common.psi.impl.RbsTypeDeclImpl;
import com.intellij.ruby.rbs.common.psi.navigators.RbsClassDeclarationNavigator;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.completion.LimitedResultSet;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementLocation;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationHints;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyCodeInsightSettings;
import org.jetbrains.plugins.ruby.util.StreamUtil;

final class RbsCompletableQualifiedNameWrapper {
    @NotNull
    private static final Logger LOG = Logger.getInstance(RbsCompletableQualifiedNameWrapper.class);
    private final Project myProject;
    private final SearchScope myResolveScope;
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final Fqn myContainerFqn;
    @NotNull
    private final String myCompletionPrefix;
    @Nullable
    private final UsageType myUsageType;
    @NotNull
    private final EnumSet<RbsQualifiedNameCompletionTarget> myCompletionTargets;
    private final boolean myIsFuzzySearch;
    private final boolean myIsGeneralCompletion;
    private final Set<Fqn> myProcessedFqns;

    RbsCompletableQualifiedNameWrapper(@NotNull RbsQualifiedNameSymbolReference reference) {
        if (reference == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(0);
        }
        this.myProcessedFqns = new HashSet<Fqn>();
        this.myProject = reference.getElement().getProject();
        this.myResolveScope = reference.getElement().getResolveScope();
        this.myElement = reference.getElement();
        this.myContainerFqn = reference.getContainerFqn();
        this.myCompletionPrefix = StringUtil.substringBeforeLast((String)reference.getQualifiedName(), (String)"IntellijIdeaRulezzz");
        this.myCompletionTargets = EnumSet.copyOf(reference.getCompletionTargets());
        this.myUsageType = reference.getUsage().getUsageType();
        this.myIsFuzzySearch = RubyCodeInsightSettings.getInstance().isFuzzySearchCompletionMode();
        this.myIsGeneralCompletion = !StringUtil.trimLeading((String)this.myCompletionPrefix, (char)':').isEmpty();
    }

    void addCompletionVariants(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(2);
        }
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(3);
        }
        List useClauses = RbsPsiUtil.getUseClauseTypes((PsiElement)this.myElement);
        RbsQualifiedNamePrefixMatcher prefixMatcher = new RbsQualifiedNamePrefixMatcher(useClauses, this.myContainerFqn, this.myCompletionPrefix, this.myIsFuzzySearch);
        CompletionResultSet resultWithPrefix = result.withPrefixMatcher((PrefixMatcher)prefixMatcher);
        CompletionSorter sorter = CompletionService.getCompletionService().defaultSorter(parameters, (PrefixMatcher)prefixMatcher);
        int limit = Registry.intValue((String)"ide.completion.variant.limit", (int)1000) / 2;
        LimitedResultSet resultWithLimit = LimitedResultSet.wrap((CompletionResultSet)resultWithPrefix, (CompletionSorter)sorter, (int)limit);
        this.addCompletionVariantsImpl(parameters, (CompletionResultSet)resultWithLimit);
    }

    @RequiresReadLock
    private void addCompletionVariantsImpl(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        List locations;
        if (parameters == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(4);
        }
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (this.myIsFuzzySearch && this.myCompletionTargets.isEmpty()) {
            return;
        }
        this.addTypeVariableLookupElements(result);
        this.addUseClauseAliasLookupElements(result);
        if (parameters.getInvocationCount() >= 2 || !this.myIsFuzzySearch || this.myIsGeneralCompletion) {
            locations = SymbolLookupElementLocation.getGeneralLocations();
        } else {
            locations = SymbolLookupElementLocation.getHighPriorityLocations();
            result.restartCompletionWhenNothingMatches();
        }
        for (SymbolLookupElementLocation location : locations) {
            if (result.isStopped()) {
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(result.getPrefixMatcher().getPrefix().length()));
                result.addLookupAdvertisement(AnalysisBundle.message((String)"completion.not.all.variants.are.shown", (Object[])new Object[0]));
                return;
            }
            SearchScope locationScope = this.getLocationScope(location);
            if (locationScope == null || locationScope == GlobalSearchScope.EMPTY_SCOPE) continue;
            this.processQualifiedNameSymbols(locationScope, location, parameters, result);
        }
    }

    private void processQualifiedNameSymbols(@NotNull SearchScope scope, @NotNull SymbolLookupElementLocation location, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (scope == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(6);
        }
        if (location == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(8);
        }
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(9);
        }
        if (!this.myIsFuzzySearch || this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.CLASS)) {
            RbsClassSymbol.stream(this.myProject, scope).forEach(it -> this.processCompletionCandidate((RbsQualifiedNameSymbol)it, location, parameters, result));
        }
        if (!this.myIsFuzzySearch || this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.MODULE)) {
            RbsModuleSymbol.stream(this.myProject, scope).forEach(it -> this.processCompletionCandidate((RbsQualifiedNameSymbol)it, location, parameters, result));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.INTERFACE)) {
            RbsInterfaceSymbol.stream(this.myProject, scope).forEach(it -> this.processCompletionCandidate((RbsQualifiedNameSymbol)it, location, parameters, result));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS)) {
            RbsTypeAliasSymbol.stream(this.myProject, scope).forEach(it -> this.processCompletionCandidate((RbsQualifiedNameSymbol)it, location, parameters, result));
        }
    }

    private void processCompletionCandidate(@NotNull RbsQualifiedNameSymbol symbol, @NotNull SymbolLookupElementLocation location, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Fqn fqn;
        if (symbol == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(10);
        }
        if (location == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(12);
        }
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(13);
        }
        if (!this.myProcessedFqns.add(fqn = symbol.getFqn())) {
            return;
        }
        if (!this.isValidCompletionCandidate(fqn, location, parameters)) {
            return;
        }
        if (this.isRecursiveSuggestion(fqn)) {
            return;
        }
        LookupElement lookupElement = RbsCompletableSymbolService.getInstance(this.myProject).asLookupElement(symbol, location);
        if (this.myCompletionPrefix.startsWith("::")) {
            result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, RbsAbsoluteQualifiedNameInsertHandler.INSTANCE));
        } else {
            result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, RbsQualifiedNameInsertHandler.INSTANCE));
        }
    }

    private boolean isRecursiveSuggestion(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(14);
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_SUPERCLASS_CLAUSE) {
            return fqn.isEquivalentTo(this.getParentClassDeclarationFqn());
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_SELF_TYPE_CLAUSE) {
            return fqn.isEquivalentTo(this.myContainerFqn);
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_TYPE_SIGNATURE) {
            return fqn.isEquivalentTo(this.getParentTypeDeclarationFqn());
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_EXTEND_INCLUDE_PREPEND_CALL) {
            return !this.isExtendInsideModule() && fqn.isEquivalentTo(this.myContainerFqn);
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_ALIAS) {
            return fqn.isEquivalentTo(this.getAliasFqn());
        }
        return false;
    }

    @NotNull
    private Fqn getParentTypeDeclarationFqn() {
        Fqn fqn = (Fqn)ObjectUtils.chooseNotNull((Object)((Fqn)ObjectUtils.doIfNotNull((Object)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RbsTypeDeclImpl.class), RbsQualifiedNameDeclaration::getFqn)), (Object)Fqn.INVALID);
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(15);
        }
        return fqn;
    }

    @NotNull
    private Fqn getParentClassDeclarationFqn() {
        Fqn fqn = Optional.ofNullable((RbsSuperClassElement)ObjectUtils.tryCast((Object)this.myElement, RbsSuperClassElement.class)).map(RbsClassDeclarationNavigator::getBySuperclass).map(RbsQualifiedNameDeclaration::getFqn).orElse(Fqn.INVALID);
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(16);
        }
        return fqn;
    }

    @NotNull
    private Fqn getAliasFqn() {
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof RbsClassAliasDeclarationElement) {
            RbsClassAliasDeclarationElement classAlias = (RbsClassAliasDeclarationElement)psiElement;
            Fqn fqn = classAlias.getFqn();
            if (fqn == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(17);
            }
            return fqn;
        }
        psiElement = this.myElement;
        if (psiElement instanceof RbsModuleAliasDeclarationElement) {
            RbsModuleAliasDeclarationElement moduleAlias = (RbsModuleAliasDeclarationElement)psiElement;
            Fqn fqn = moduleAlias.getFqn();
            if (fqn == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(18);
            }
            return fqn;
        }
        Fqn fqn = Fqn.INVALID;
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(19);
        }
        return fqn;
    }

    private boolean isExtendInsideModule() {
        return this.myElement instanceof RbsExtendMember && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RbsContainerDeclarationElement.class) instanceof RbsModuleDeclarationElement;
    }

    private void addTypeVariableLookupElements(@NotNull CompletionResultSet result) {
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(20);
        }
        Stream<RbsTypeVariableSymbol> symbols = Stream.empty();
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.CONTAINER_TYPE_VARIABLE)) {
            symbols = Stream.concat(symbols, this.findSymbols(RbsContainerDeclarationElement.class, it -> ExtensionsKt.getSymbols((PsiElement)it, RbsTypeVariableSymbol.class)));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.METHOD_TYPE_VARIABLE)) {
            symbols = Stream.concat(symbols, this.findSymbols(RbsMethodTypeElement.class, methodType -> {
                RbsMethodDeclarationElement methodDeclaration = (RbsMethodDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)methodType, RbsMethodDeclarationElement.class);
                if (methodDeclaration == null) {
                    return Collections.emptyList();
                }
                return ExtensionsKt.getSymbolDeclarations((PsiElement)methodDeclaration, (PsiSymbolDeclarationHints)PsiSymbolDeclarationHints.symbolClassHint(RbsMethodTypeVariableSymbol.class)).stream().filter(declaration -> methodType.getTextRange().contains(declaration.getAbsoluteRange())).map(PsiSymbolDeclaration::getSymbol).mapMulti(StreamUtil.select(RbsMethodTypeVariableSymbol.class, (Class[])new Class[0])).toList();
            }));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS_TYPE_VARIABLE)) {
            symbols = Stream.concat(symbols, this.findSymbols(RbsTypeDeclarationElement.class, it -> ExtensionsKt.getSymbols((PsiElement)it, RbsTypeVariableSymbol.class)));
        }
        symbols.map(RbsCompletableSymbolService.getInstance(this.myProject)::asLookupElement).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    private void addUseClauseAliasLookupElements(@NotNull CompletionResultSet result) {
        Object object;
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(21);
        }
        if (!((object = this.myElement.getContainingFile()) instanceof RbsPsiFile)) {
            return;
        }
        RbsPsiFile file = (RbsPsiFile)object;
        for (RbsUseClauseAliasSymbol symbol : ContainerUtil.mapNotNull((Collection)file.getUseClauses(), it -> (RbsUseClauseAliasSymbol)ExtensionsKt.getSymbol((PsiElement)it, RbsUseClauseAliasSymbol.class))) {
            List<RbsQualifiedNameSymbol> targets = RbsQualifiedNameSymbol.find(this.myProject, this.myResolveScope, symbol.getTargetFqn()).filter(target -> {
                if (target instanceof RbsClassSymbol) {
                    return this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.CLASS);
                }
                if (target instanceof RbsInterfaceSymbol) {
                    return this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.INTERFACE);
                }
                if (target instanceof RbsModuleSymbol) {
                    return this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.MODULE);
                }
                if (target instanceof RbsTypeAliasSymbol) {
                    return this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS);
                }
                return false;
            }).toList();
            if (targets.isEmpty()) continue;
            result.addElement(RbsCompletableSymbolService.getInstance(this.myProject).asLookupElement(symbol, targets));
        }
    }

    @NotNull
    private <E extends PsiElement, S extends RbsTypeVariableSymbol> Stream<S> findSymbols(@NotNull Class<E> parentClass, @NotNull Function<E, List<S>> toSymbols) {
        PsiElement parent;
        if (parentClass == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(22);
        }
        if (toSymbols == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(23);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)this.myElement, parentClass)) == null) {
            Stream stream = Stream.empty();
            if (stream == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(24);
            }
            return stream;
        }
        Stream stream = toSymbols.apply(parent).stream();
        if (stream == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(25);
        }
        return stream;
    }

    @NotNull
    private GlobalSearchScope getCoreLibraryScope() {
        VirtualFile coreDirectory;
        Project project = this.myElement.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        VirtualFile virtualFile = coreDirectory = module != null ? RbsRubysigsLibraryUtil.getRbsCoreLibraryRoot(project, module) : null;
        if (coreDirectory == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("Can't find 'rbs/core' directory");
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(26);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)coreDirectory, (boolean)true);
        if (globalSearchScope == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @Nullable
    private SearchScope getLocationScope(@NotNull SymbolLookupElementLocation location) {
        if (location == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(28);
        }
        if (location == SymbolLookupElementLocation.SDK) {
            return GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)this.myResolveScope.intersectWith((SearchScope)this.getCoreLibraryScope()), (Project)this.myProject);
        }
        return location.restrictSearchScope(this.myProject, this.myResolveScope, this.myElement);
    }

    private boolean isValidCompletionCandidate(@NotNull Fqn fqn, @NotNull SymbolLookupElementLocation location, @NotNull CompletionParameters parameters) {
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(29);
        }
        if (location == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(30);
        }
        if (parameters == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(31);
        }
        if (parameters.getInvocationCount() >= 2 || !this.myIsFuzzySearch || this.myIsGeneralCompletion) {
            return true;
        }
        return location != SymbolLookupElementLocation.SDK || StringUtil.getOccurrenceCount((String)fqn.join(true), (String)"::") == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 18, 19, 24, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 11: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsCompletableQualifiedNameWrapper";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsCompletableQualifiedNameWrapper";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentTypeDeclarationFqn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentClassDeclarationFqn";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasFqn";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findSymbols";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariantsImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedNameSymbols";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processCompletionCandidate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveSuggestion";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addTypeVariableLookupElements";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addUseClauseAliasLookupElements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findSymbols";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLocationScope";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isValidCompletionCandidate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 18, 19, 24, 25, 26, 27 -> new IllegalStateException(string);
        };
    }
}

