/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.codeInsight.intentions.preview;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.model.Symbol;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.RbsFileType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;

public final class RbsIntentionPreviewInfoUtil {
    private RbsIntentionPreviewInfoUtil() {
    }

    @NotNull
    public static IntentionPreviewInfo generateEditPreview(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol) {
        if (project == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(2);
        }
        return RbsIntentionPreviewInfoUtil.generateSymbolPreview(project, searchScope, symbol);
    }

    @NotNull
    public static IntentionPreviewInfo generateNavigatePreview(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol) {
        if (project == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(4);
        }
        if (symbol == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(5);
        }
        return RbsIntentionPreviewInfoUtil.generateSymbolPreview(project, searchScope, symbol);
    }

    @NotNull
    private static IntentionPreviewInfo generateSymbolPreview(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol) {
        if (project == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(7);
        }
        if (symbol == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(8);
        }
        Ref declarationRef = new Ref();
        RbsPsiSymbolDeclarationSearcher.processDeclarations(project, searchScope, symbol, (Processor<? super RbsPsiSymbolDeclaration>)((Processor)it -> {
            declarationRef.set((Object)it.getDeclaringElement());
            return false;
        }));
        PsiElement declaration = (PsiElement)declarationRef.get();
        if (declaration == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        String filename = (String)ObjectUtils.doIfNotNull((Object)PsiUtilCore.getVirtualFile((PsiElement)declaration), file -> TargetPresentationUtil.getRelativePath((Project)project, (VirtualFile)file));
        String indent = " ".repeat(RbsIntentionPreviewInfoUtil.getLineIndent(project, declaration));
        String text = declaration.getText().lines().map(it -> StringUtil.trimStart((String)it, (String)indent)).collect(Collectors.joining("\n"));
        return new IntentionPreviewInfo.CustomDiff((FileType)RbsFileType.INSTANCE, filename, "", text);
    }

    private static int getLineIndent(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            RbsIntentionPreviewInfoUtil.$$$reportNull$$$0(11);
        }
        Document document = (Document)ObjectUtils.doIfNotNull((Object)element.getContainingFile(), arg_0 -> ((PsiDocumentManager)PsiDocumentManager.getInstance((Project)project)).getDocument(arg_0));
        if (document == null) {
            return 0;
        }
        int offset = element.getTextOffset();
        int lineOffset = document.getLineStartOffset(document.getLineNumber(offset));
        return Math.max(offset - lineOffset, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/codeInsight/intentions/preview/RbsIntentionPreviewInfoUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/codeInsight/intentions/preview/RbsIntentionPreviewInfoUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSymbolPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateEditPreview";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateNavigatePreview";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateSymbolPreview";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

