/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.actions;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.NewFileActionWithCategory;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.lang.ruby.rbs.RbsSupport;
import com.intellij.lang.ruby.rbs.statistics.RbsCreateFileFromTemplateCollector;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.ruby.rbs.common.util.RbsNamingConventionUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RbsCreateClassFileAction
extends CreateFileFromTemplateAction
implements DumbAware,
NewFileActionWithCategory {
    public static final InputValidatorEx RBS_CLASS_VALIDATOR = new InputValidator("RBS Class");
    public static final InputValidatorEx RBS_MODULE_VALIDATOR = new InputValidator("RBS Module");
    public static final InputValidatorEx RBS_INTERFACE_VALIDATOR = new InputValidator("RBS Interface");
    public static final InputValidatorEx RBS_FILE_VALIDATOR = new InputValidator("RBS File");
    private static final Logger LOG = Logger.getInstance(RbsCreateClassFileAction.class);

    private RbsCreateClassFileAction() {
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        if (project == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(2);
        }
        builder.setTitle(RbsBundle.message((String)"rbs.actions.create.class.file.title", (Object[])new Object[0])).addKind(RbsBundle.message((String)"rbs.actions.create.class.file.dialog.class", (Object[])new Object[0]), RbsIcons.RBS_CLASS_ICON, "RBS Class", (com.intellij.openapi.ui.InputValidator)RBS_CLASS_VALIDATOR).addKind(RbsBundle.message((String)"rbs.actions.create.class.file.dialog.module", (Object[])new Object[0]), RbsIcons.RBS_MODULE_ICON, "RBS Module", (com.intellij.openapi.ui.InputValidator)RBS_MODULE_VALIDATOR).addKind(RbsBundle.message((String)"rbs.actions.create.class.file.dialog.interface", (Object[])new Object[0]), RbsIcons.RBS_INTERFACE_ICON, "RBS Interface", (com.intellij.openapi.ui.InputValidator)RBS_INTERFACE_VALIDATOR).addKind(RbsBundle.message((String)"rbs.actions.create.class.file.dialog.file", (Object[])new Object[0]), RbsIcons.RBS_FILE_ICON, "RBS File", (com.intellij.openapi.ui.InputValidator)RBS_FILE_VALIDATOR);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @Nullable
    public PsiFile createFile(@NotNull String name, @NotNull String templateName, @NotNull PsiDirectory dir) {
        if (name == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(3);
        }
        if (templateName == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(4);
        }
        if (dir == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(5);
        }
        return super.createFile(name, templateName, dir);
    }

    @Nullable
    protected PsiFile createFileFromTemplate(@NotNull String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir) {
        if (name == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(6);
        }
        if (template == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            template.setReformatCode(false);
        }
        RbsCreateFileFromTemplateCollector.logCreatedEvent(template);
        String templateName = template.getName();
        if (templateName.equals("RBS File")) {
            return RbsCreateClassFileAction.createFileFromTemplate((String)name, (FileTemplate)template, (PsiDirectory)dir, null, (boolean)true);
        }
        Project project = dir.getProject();
        Fqn fqn = Fqn.of((String)name, (String[])new String[0]).split();
        String filename = NamingConventions.toUnderscoreCase((String)fqn.getName());
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        properties.setProperty("NAME", name);
        try {
            PsiFile file = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)filename, (Properties)properties, (PsiDirectory)dir).getContainingFile();
            if (template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate((PsiFile)file);
            }
            return file;
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName, @NotNull String templateName) {
        if (directory == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(10);
        }
        if (templateName == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(11);
        }
        String string = RbsBundle.message((String)"rbs.actions.create.class.file.name", (Object[])new Object[]{newName});
        if (string == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isAvailable(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RbsCreateClassFileAction.$$$reportNull$$$0(13);
        }
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Project project = Objects.requireNonNull((Project)CommonDataKeys.PROJECT.getData(dataContext));
        Module module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
        return RbsSupport.isRbsUsedInProject(project, module);
    }

    @NotNull
    public String getCategory() {
        return "Ruby";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/actions/RbsCreateClassFileAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/actions/RbsCreateClassFileAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDialog";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromTemplate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final class InputValidator
    implements InputValidatorEx {
        private final String myKind;

        @VisibleForTesting
        @ApiStatus.Internal
        public InputValidator(@NotNull String kind) {
            if (kind == null) {
                InputValidator.$$$reportNull$$$0(0);
            }
            this.myKind = kind;
        }

        @Nullable
        public String getErrorText(@NotNull String input) {
            if (input == null) {
                InputValidator.$$$reportNull$$$0(1);
            }
            switch (this.myKind) {
                case "RBS Class": {
                    if (!input.startsWith("::") && RbsNamingConventionUtils.isValidClassName((String)input)) break;
                    return RbsBundle.message((String)"rbs.actions.create.class.file.error.invalid.class.name", (Object[])new Object[0]);
                }
                case "RBS Module": {
                    if (!input.startsWith("::") && RbsNamingConventionUtils.isValidModuleName((String)input)) break;
                    return RbsBundle.message((String)"rbs.actions.create.class.file.error.invalid.module.name", (Object[])new Object[0]);
                }
                case "RBS Interface": {
                    if (!input.startsWith("::") && RbsNamingConventionUtils.isValidClassName((String)input)) break;
                    return RbsBundle.message((String)"rbs.actions.create.class.file.error.invalid.interface.name", (Object[])new Object[0]);
                }
                case "RBS File": {
                    if (PathUtil.isValidFileName((String)input)) break;
                    return RbsBundle.message((String)"rbs.actions.create.class.file.error.invalid.file.name", (Object[])new Object[0]);
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown kind: %s", this.myKind));
                }
            }
            return null;
        }

        public boolean canClose(@NotNull String input) {
            if (input == null) {
                InputValidator.$$$reportNull$$$0(2);
            }
            return StringUtil.isNotEmpty((String)input) && this.getErrorText(input) == null;
        }

        public boolean checkInput(@NotNull String input) {
            if (input == null) {
                InputValidator.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/actions/RbsCreateClassFileAction$InputValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkInput";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

