/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ruby.rbs.common.RbsFileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RbsSupport {
    private RbsSupport() {
    }

    public static boolean isRbsGemUsedInProject(@NotNull Project project) {
        if (project == null) {
            RbsSupport.$$$reportNull$$$0(0);
        }
        return ContainerUtil.exists((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(project), it -> RubyProjectGemSearchService.Companion.findGem(it, "rbs") != null);
    }

    public static boolean isRbsGemExplicitlyUsedInProject(@NotNull Project project) {
        if (project == null) {
            RbsSupport.$$$reportNull$$$0(1);
        }
        for (Module module : RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
            Set requirements = ModuleGemInfrastructure.getInstance((Module)module).getRequirements();
            if (!ContainerUtil.exists((Iterable)requirements, it -> it.getName().equals("rbs"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isRbsUsedInProject(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            RbsSupport.$$$reportNull$$$0(2);
        }
        Sdk sdk = RubySdkUtil.findRubySdk((Project)project);
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        if (sdk != null && ((Boolean)ReadAction.compute(() -> FileTypeIndex.containsFileOfType((FileType)RbsFileType.INSTANCE, (GlobalSearchScope)searchScope))).booleanValue()) {
            return true;
        }
        return module != null && RubyProjectGemSearchService.Companion.findGem(module, "rbs") != null;
    }

    public static boolean isRbsUsedInProject(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            RbsSupport.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RbsSupport.$$$reportNull$$$0(4);
        }
        return RbsSupport.isRbsUsedInProject(project, ModuleUtilCore.findModuleForFile((PsiFile)file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/RbsSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRbsGemUsedInProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRbsGemExplicitlyUsedInProject";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRbsUsedInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

