/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.utils.RubyInflectionsProvider;

public final class NamingConventions {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("[A-Z][A-Za-z0-9]*");
    private static final Pattern CAMEL_CASE_EXT_PATTERN = Pattern.compile("((::)?[A-Z][A-Za-z0-9]*)*");
    private static final Pattern SNAKE_CASE_PATTERN = Pattern.compile("[a-z_][a-z0-9_]*");
    private static final Pattern SNAKE_CASE_EXT_PATTERN = Pattern.compile("[a-z_/][a-z0-9_/]*");

    private NamingConventions() {
    }

    public static boolean isInCamelCase(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && CAMEL_CASE_PATTERN.matcher(name).matches();
    }

    public static boolean isInCamelCaseExt(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && CAMEL_CASE_EXT_PATTERN.matcher(name).matches();
    }

    public static boolean isInUnderscoredCase(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && SNAKE_CASE_PATTERN.matcher(name).matches();
    }

    public static boolean isInUnderscoredCaseExt(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && SNAKE_CASE_EXT_PATTERN.matcher(name).matches();
    }

    @NotNull
    public static String toCamelCase(@Nullable String name) {
        if (name == null || name.isBlank()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        boolean isUpperCase = true;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch == '_' && i + 1 < length && name.charAt(i + 1) == '_') continue;
            if (i + 1 < length && (i > 0 && ch == '_' && name.charAt(i - 1) != '_' || ch == ':' && name.charAt(i + 1) == ':') || ch == '/') {
                isUpperCase = true;
                if (ch == ':') {
                    buffer.append(RubyTokenTypes.tCOLON2);
                    ++i;
                    continue;
                }
                if (ch != '/') continue;
                buffer.append(RubyTokenTypes.tCOLON2);
                continue;
            }
            if (Character.isUpperCase(ch)) {
                isUpperCase = true;
            }
            buffer.append(isUpperCase ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
            isUpperCase = false;
        }
        String string = buffer.toString();
        if (string == null) {
            NamingConventions.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String toCamelCase(@Nullable String name, @Nullable Module module) {
        if (name != null && module != null) {
            for (RubyInflectionsProvider provider : RubyInflectionsProvider.EP_NAME.getExtensionList()) {
                String camelized = provider.camelize(name, module);
                if (camelized == null) continue;
                String string = camelized;
                if (string == null) {
                    NamingConventions.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        return NamingConventions.toCamelCase(name);
    }

    @NotNull
    public static String toUnderscoreCase(@Nullable String name) {
        return NamingConventions.toUnderscoreCase(name, true);
    }

    @NotNull
    public static String toUnderscoreCase(@Nullable String name, @Nullable Module module) {
        if (name != null && module != null) {
            for (RubyInflectionsProvider provider : RubyInflectionsProvider.EP_NAME.getExtensionList()) {
                String underscored = provider.underscore(name, module);
                if (underscored == null) continue;
                String string = underscored;
                if (string == null) {
                    NamingConventions.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        return NamingConventions.toUnderscoreCase(name, true);
    }

    @NotNull
    public static String toUnderscoreCase(@Nullable String name, boolean underscoreBlockOfCapitals) {
        if (name == null || name.isBlank()) {
            return "";
        }
        String normalizedName = StringUtil.replace((String)name, (String)"::", (String)"/");
        StringBuilder buffer = new StringBuilder();
        int length = normalizedName.length();
        for (int i = 0; i < length; ++i) {
            char chNext;
            char ch = normalizedName.charAt(i);
            if (ch != '-') {
                buffer.append(Character.toLowerCase(ch));
            } else {
                buffer.append("_");
            }
            if (!Character.isLetterOrDigit(ch)) continue;
            if (underscoreBlockOfCapitals && Character.isUpperCase(ch)) {
                if (i + 2 >= length) continue;
                chNext = normalizedName.charAt(i + 1);
                char chNextNext = normalizedName.charAt(i + 2);
                if (!Character.isUpperCase(chNext) || !Character.isLowerCase(chNextNext)) continue;
                buffer.append('_');
                continue;
            }
            if (!Character.isLowerCase(ch) && !Character.isDigit(ch) || i + 1 >= length || !Character.isUpperCase(chNext = normalizedName.charAt(i + 1))) continue;
            buffer.append('_');
        }
        String string = buffer.toString();
        if (string == null) {
            NamingConventions.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/utils/NamingConventions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toCamelCase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnderscoreCase";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

