/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.sorbet;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.RSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.ModuleOrClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RMethodWithPossibleInlineVisibilityModifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class SorbetSigParser {
    public static final String SIG = "sig";
    public static final String VOID = "void";
    public static final String RETURNS = "returns";
    public static final String PARAMS = "params";
    public static final String BOOLEAN = "T::Boolean";
    public static final String TYPENAME_T = "T";
    public static final Set<String> COLLECTION_WRAPPERS = Set.of("T::Array", "T::Set", "T::Enumerable", "T::Range", "Array", "Set", "Enumerable", "Range");
    private static final Set<String> HASH_WRAPPERS = Set.of("T::Hash", "Hash");
    public static final String UNION_TYPE = "T.any";
    public static final String CLASS_TYPE = "T.class_of";
    private static final String PROC_PREFIX = "T.proc.";
    public static final String PROC = "proc";
    public static final String BIND = "bind";
    public static final String UNTYPED = "T.untyped";

    private SorbetSigParser() {
    }

    @Nullable
    public static RSignature parse(@NotNull PsiElement signatureStatement) {
        if (signatureStatement == null) {
            SorbetSigParser.$$$reportNull$$$0(0);
        }
        if (!(signatureStatement instanceof RBlockCall)) {
            return null;
        }
        RPsiElement nextSibling = (RPsiElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)signatureStatement, RPsiElement.class);
        if (RMethodWithPossibleInlineVisibilityModifier.from((PsiElement)nextSibling) == null) {
            return null;
        }
        if (!SIG.equals(((RBlockCall)signatureStatement).getCall().getCommand())) {
            return null;
        }
        return SorbetSigParser.parseMethodSignature(((RBlockCall)signatureStatement).getBlock().getCompoundStatement());
    }

    @Nullable
    private static RSignature parseMethodSignature(RCompoundStatement statement) {
        List statements = statement.getStatements();
        if (statements.size() != 1) {
            return null;
        }
        RPsiElement call = (RPsiElement)statements.iterator().next();
        List<Pair<@Nullable String, @Nullable RListOfExpressions>> chainedCall = SorbetSigParser.decomposeChainedCall((PsiElement)call);
        Pair<String, RListOfExpressions> returns = !chainedCall.isEmpty() ? chainedCall.get(chainedCall.size() - 1) : null;
        Pair<String, RListOfExpressions> params = chainedCall.size() > 1 ? chainedCall.get(chainedCall.size() - 2) : null;
        return new RSignature(SorbetSigParser.parseParams(params), SorbetSigParser.parseReturns(returns));
    }

    @NotNull
    private static List<RSignature.TypedArgument> parseParams(@Nullable @Nullable Pair<@Nullable String, @Nullable RListOfExpressions> params) {
        if (params == null || !PARAMS.equals(params.getFirst()) || params.getSecond() == null) {
            List<RSignature.TypedArgument> list = Collections.emptyList();
            if (list == null) {
                SorbetSigParser.$$$reportNull$$$0(1);
            }
            return list;
        }
        List arguments = ((RListOfExpressions)params.getSecond()).getElements();
        ArrayList<RSignature.TypedArgument> result = new ArrayList<RSignature.TypedArgument>(arguments.size());
        for (RPsiElement argument : arguments) {
            if (!(argument instanceof RAssoc)) continue;
            String argumentName = ((RAssoc)argument).getKeyText();
            RPsiElement argumentValue = ((RAssoc)argument).getValue();
            if (StringUtil.isEmpty((String)argumentName) || argumentValue == null) continue;
            result.add(new RSignature.TypedArgument(argumentName, SorbetSigParser.parseType((PsiElement)argumentValue)));
        }
        ArrayList<RSignature.TypedArgument> arrayList = result;
        if (arrayList == null) {
            SorbetSigParser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static SerializableType parseReturns(@Nullable @Nullable Pair<@Nullable String, @Nullable RListOfExpressions> returnsCall) {
        if (returnsCall == null) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(3);
            }
            return serializableType;
        }
        RListOfExpressions argumentsExpr = (RListOfExpressions)returnsCall.getSecond();
        if (VOID.equals(returnsCall.getFirst()) && argumentsExpr == null) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(4);
            }
            return serializableType;
        }
        if (argumentsExpr == null) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(5);
            }
            return serializableType;
        }
        List arguments = argumentsExpr.getElements();
        if (!RETURNS.equals(returnsCall.getFirst()) || arguments.size() != 1) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(6);
            }
            return serializableType;
        }
        return SorbetSigParser.parseType((PsiElement)arguments.iterator().next());
    }

    @NotNull
    private static SerializableType parseType(@Nullable PsiElement typeWithPossibleGenerics) {
        if (typeWithPossibleGenerics == null) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(7);
            }
            return serializableType;
        }
        Pair<? extends PsiElement, List<? extends PsiElement>> pair = SorbetSigParser.extractGenerics(typeWithPossibleGenerics);
        PsiElement typeValue = (PsiElement)pair.getFirst();
        List genericValues = (List)pair.getSecond();
        String valueText = typeValue.getText();
        if (typeValue instanceof RConstant || typeValue instanceof RColonReference) {
            if (COLLECTION_WRAPPERS.contains(valueText)) {
                SerializableType serializableType = SerializableTypeUtil.createCollectionType(SerializableTypeUtil.createFullyQualifiedType(SorbetSigParser.unwrapStdClass(valueText)), genericValues.isEmpty() ? SerializableTypeUtil.EMPTY : SorbetSigParser.parseType((PsiElement)genericValues.get(0)));
                if (serializableType == null) {
                    SorbetSigParser.$$$reportNull$$$0(8);
                }
                return serializableType;
            }
            if (HASH_WRAPPERS.contains(valueText)) {
                SerializableType serializableType = SerializableTypeUtil.createHashType(SerializableTypeUtil.createFullyQualifiedType("Hash"), genericValues.isEmpty() ? SerializableTypeUtil.EMPTY : SorbetSigParser.parseType((PsiElement)genericValues.get(0)), genericValues.size() < 2 ? SerializableTypeUtil.EMPTY : SorbetSigParser.parseType((PsiElement)genericValues.get(1)));
                if (serializableType == null) {
                    SorbetSigParser.$$$reportNull$$$0(9);
                }
                return serializableType;
            }
            if (BOOLEAN.equals(valueText)) {
                SerializableType serializableType = SerializableTypeUtil.BOOLEAN;
                if (serializableType == null) {
                    SorbetSigParser.$$$reportNull$$$0(10);
                }
                return serializableType;
            }
            if (TYPENAME_T.equals(valueText)) {
                return genericValues.isEmpty() ? SerializableTypeUtil.EMPTY : new ModuleOrClassType(SorbetSigParser.parseType((PsiElement)genericValues.get(0)));
            }
            SerializableType serializableType = SerializableTypeUtil.createQualifiedType(valueText);
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(11);
            }
            return serializableType;
        }
        if (typeValue instanceof RCall && UNION_TYPE.equals(((RCall)typeValue).getCommand())) {
            SerializableType serializableType = SerializableTypeUtil.createUnionType(ContainerUtil.map((Collection)((RCall)typeValue).getArguments(), SorbetSigParser::parseType));
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(12);
            }
            return serializableType;
        }
        if (typeValue instanceof RDotReference && UNTYPED.equals(typeValue.getText())) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(13);
            }
            return serializableType;
        }
        if (valueText.startsWith(PROC_PREFIX)) {
            return SorbetSigParser.parseProcType(typeValue);
        }
        SerializableType serializableType = SerializableTypeUtil.EMPTY;
        if (serializableType == null) {
            SorbetSigParser.$$$reportNull$$$0(14);
        }
        return serializableType;
    }

    @NotNull
    private static SerializableType parseProcType(PsiElement call) {
        List<Pair<@Nullable String, @Nullable RListOfExpressions>> chainedCall = SorbetSigParser.decomposeChainedCall(call);
        if (chainedCall.size() < 3) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                SorbetSigParser.$$$reportNull$$$0(15);
            }
            return serializableType;
        }
        assert (TYPENAME_T.equals(chainedCall.get(0).getFirst()) && PROC.equals(chainedCall.get(1).getFirst()));
        SerializableType bindType = BIND.equals(chainedCall.get(2).getFirst()) && chainedCall.get(2).getSecond() != null ? SorbetSigParser.parseType((PsiElement)((RListOfExpressions)chainedCall.get(2).getSecond()).getFirstElement()) : SerializableTypeUtil.EMPTY;
        Pair<@Nullable String, @Nullable RListOfExpressions> returns = chainedCall.get(chainedCall.size() - 1);
        Pair<@Nullable String, @Nullable RListOfExpressions> params = chainedCall.get(chainedCall.size() - 2);
        SerializableType serializableType = SerializableTypeUtil.createProcType(bindType, new RSignature(SorbetSigParser.parseParams(params), SorbetSigParser.parseReturns(returns)));
        if (serializableType == null) {
            SorbetSigParser.$$$reportNull$$$0(16);
        }
        return serializableType;
    }

    private static Pair<? extends PsiElement, List<? extends PsiElement>> extractGenerics(@NotNull PsiElement element) {
        if (element == null) {
            SorbetSigParser.$$$reportNull$$$0(17);
        }
        if (element instanceof RArrayIndexing) {
            return Pair.create((Object)((RArrayIndexing)element).getReceiver(), (Object)((RArrayIndexing)element).getIndexes());
        }
        if (element instanceof RCall && CLASS_TYPE.equals(((RCall)element).getCommand())) {
            return Pair.create((Object)((RCall)element).getReceiver(), (Object)((RCall)element).getArguments());
        }
        return Pair.create((Object)element, Collections.emptyList());
    }

    private static @NotNull List<Pair<@Nullable String, @Nullable RListOfExpressions>> decomposeChainedCall(@NotNull PsiElement call) {
        if (call == null) {
            SorbetSigParser.$$$reportNull$$$0(18);
        }
        ArrayList<Pair> result = new ArrayList<Pair>();
        while (call != null) {
            RListOfExpressions params;
            RListOfExpressions rListOfExpressions = params = call instanceof RCall ? ((RCall)call).getCallArguments() : null;
            if (call instanceof RCall) {
                call = ((RCall)call).getPsiCommand();
            }
            String name = call instanceof RDotReference ? ((RDotReference)call).getCommand() : call.getText();
            result.add(Pair.create((Object)name, (Object)params));
            if (!(call instanceof RDotReference)) break;
            call = ((RDotReference)call).getReceiver();
        }
        List list = ContainerUtil.reverse(result);
        if (list == null) {
            SorbetSigParser.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static String unwrapStdClass(@NotNull String maybeWrappedClass) {
        if (maybeWrappedClass == null) {
            SorbetSigParser.$$$reportNull$$$0(20);
        }
        return (String)ObjectUtils.coalesce((Object)StringUtil.substringAfter((String)maybeWrappedClass, (String)"::"), (Object)maybeWrappedClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureStatement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/sorbet/SorbetSigParser";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeWrappedClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/sorbet/SorbetSigParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseParams";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturns";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseProcType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "decomposeChainedCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractGenerics";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "decomposeChainedCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unwrapStdClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

