/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeWithScopeContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubNamespaceElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.RubyPsiElementStub;

public class RBlockCallStubImpl
extends RubyPsiElementStub<RBlockCall>
implements RBlockCallStub {
    private final RubyCallTypeBase.Data<?> myCallStorage;
    private final String myCommandName;
    private final String myReceiver;
    private final Map<String, DocumentationSymbol<?>> myDocumentationSymbols;
    private final NotNullLazyValue<FQN> myFQNWithNesting;

    public RBlockCallStubImpl(StubElement parent, IElementType elementType, @NotNull RubyCallTypeBase.Data<?> callData, String commandName, String receiver, @NotNull Map<String, DocumentationSymbol<?>> documentationSymbols) {
        if (callData == null) {
            RBlockCallStubImpl.$$$reportNull$$$0(0);
        }
        if (documentationSymbols == null) {
            RBlockCallStubImpl.$$$reportNull$$$0(1);
        }
        super(parent, elementType);
        this.myFQNWithNesting = NotNullLazyValue.createValue(() -> RStubNamespaceElement.getFQNForStub((RStubElement)this, (FQN)this.getFQN()));
        this.myCallStorage = callData;
        this.myCommandName = commandName;
        this.myReceiver = receiver;
        this.myDocumentationSymbols = Collections.unmodifiableMap(new LinkedHashMap(documentationSymbols));
    }

    @NotNull
    public RubyCallTypeBase.Data<?> getCallData() {
        RubyCallTypeBase.Data<?> data = this.myCallStorage;
        if (data == null) {
            RBlockCallStubImpl.$$$reportNull$$$0(2);
        }
        return data;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    @Nullable
    public String getReferenceReceiver() {
        return this.myReceiver;
    }

    @NotNull
    public Map<String, DocumentationSymbol<?>> getDocumentationSymbols() {
        Map<String, DocumentationSymbol<?>> map = this.myDocumentationSymbols;
        if (map == null) {
            RBlockCallStubImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public FQN getFQN() {
        RubyCallTypeWithScopeContext callType = (RubyCallTypeWithScopeContext)ObjectUtils.tryCast((Object)this.getCallData().getCallType(), RubyCallTypeWithScopeContext.class);
        FQN fQN = callType != null ? callType.getScopeContext((RBlockCallStub)this) : FQN.INVALID;
        if (fQN == null) {
            RBlockCallStubImpl.$$$reportNull$$$0(4);
        }
        return fQN;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        FQN fQN = (FQN)this.myFQNWithNesting.getValue();
        if (fQN == null) {
            RBlockCallStubImpl.$$$reportNull$$$0(5);
        }
        return fQN;
    }

    public String toString() {
        return "RBlockCallStubImpl{myCallStorage=%s, myCommandName='%s', myReceiver='%s', myDocumentationSymbols=%s}".formatted(this.myCallStorage, this.myCommandName, this.myReceiver, this.myDocumentationSymbols);
    }

    public boolean isValidNamespace() {
        return this.getCallData().getCallType() instanceof RubyCallTypeWithScopeContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationSymbols";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/impl/RBlockCallStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/impl/RBlockCallStubImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationSymbols";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

