/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.EmptyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.InstanceEvalExecCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyFileCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubySendCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.StructClassNameFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.StructNewCallType;

public final class RubyCallTypesCore {
    @NonNls
    public static final String REQUIRE_COMMAND = "require";
    public static final RubyCallType<List<String>> REQUIRE_CALL = new RubyFileCallType("require").withIcon(() -> AllIcons.Nodes.Aspect);
    @NonNls
    public static final String REQUIRE_RELATIVE_COMMAND = "require_relative";
    public static final RubyCallType<List<String>> REQUIRE_RELATIVE_CALL = new RubyFileCallType("require_relative").withIcon(() -> AllIcons.Nodes.Aspect);
    @NonNls
    public static final String PRIVATE_COMMAND = "private";
    @NonNls
    public static final String PUBLIC_COMMAND = "public";
    @NonNls
    public static final String PROTECTED_COMMAND = "protected";
    @NonNls
    public static final String KIND_OF = "kind_of?";
    @NonNls
    public static final String IS_A = "is_a?";
    @NonNls
    public static final String RESPOND_TO = "respond_to?";
    @NonNls
    public static final String ALIAS_COMMAND = "alias_method";
    public static final RubyCallType<List<FQN>> CLASS_EVAL = new AnonymousDefiningCallType("class_eval");
    public static final RubyCallType<List<FQN>> MODULE_EVAL = new AnonymousDefiningCallType("module_eval");
    public static final RubyCallType<List<FQN>> INSTANCE_EVAL = new InstanceEvalExecCallType("instance_eval");
    public static final RubyCallType<List<FQN>> INSTANCE_EXEC = new InstanceEvalExecCallType("instance_exec");
    public static final Set<RubyCallType<?>> EVAL_AND_EXEC_CALLS = Set.of(CLASS_EVAL, MODULE_EVAL, INSTANCE_EVAL, INSTANCE_EXEC);
    public static final RubyCallType<List<String>> LOAD_CALL = new RubyFileCallType("load").withIcon(() -> AllIcons.Nodes.Aspect);
    public static final RubyCallType<List<String>> AUTOLOAD_AT_CALL = new RubyFileCallType("autoload_at");
    public static final RubyCallType<Void> RAISE_CALL = new EmptyCallType("raise");
    public static final RubyCallType<Void> FAIL_CALL = new EmptyCallType("fail");
    public static final RubyCallType<Void> THROW_CALL = new EmptyCallType("throw");
    public static final RubyCallType<Void> CATCH_CALL = new EmptyCallType("catch");
    public static final RubyCallType<List<FQN>> INCLUDED_DO = new AnonymousDefiningCallType("included");
    public static final RubyCallType<List<FQN>> SEND_CALL = new RubySendCallType();

    private RubyCallTypesCore() {
    }

    public static boolean isEvalOrExec(@Nullable RubyCallType<?> callType) {
        return callType != null && EVAL_AND_EXEC_CALLS.contains(callType);
    }

    public static boolean isInstanceEvalOrInstanceExec(@Nullable RubyCallType<?> callType) {
        return callType == INSTANCE_EVAL || callType == INSTANCE_EXEC;
    }

    public static boolean isIncludedDo(@Nullable RubyCallType<?> callType) {
        return callType == INCLUDED_DO;
    }

    public static boolean isExtendCall(RPossibleCall call) {
        RubyCallType callType = call.getCallType();
        if (callType == RubyIncludeExtendCallTypes.EXTEND_CALL) {
            return true;
        }
        if (callType != SEND_CALL) {
            return false;
        }
        List args = (List)call.getData(new RubyCallType[]{SEND_CALL});
        return args.size() > 1 && "extend".equals(((FQN)args.get(0)).getShortName());
    }

    public static boolean isPrependCall(RPossibleCall call) {
        RubyCallType callType = call.getCallType();
        if (callType == RubyIncludeExtendCallTypes.PREPEND_CALL) {
            return true;
        }
        if (callType != SEND_CALL) {
            return false;
        }
        List args = (List)call.getData(new RubyCallType[]{SEND_CALL});
        return args.size() > 1 && "prepend".equals(((FQN)args.get(0)).getShortName());
    }

    public static boolean isIncludeOrPrependCall(RPossibleCall call) {
        return RubyCallTypesCore.isIncludeCall(call) || RubyCallTypesCore.isPrependCall(call);
    }

    public static boolean isIncludeCall(RPossibleCall call) {
        RubyCallType callType = call.getCallType();
        if (callType == RubyIncludeExtendCallTypes.INCLUDE_CALL) {
            return true;
        }
        if (callType != SEND_CALL) {
            return false;
        }
        List args = (List)call.getData(new RubyCallType[]{SEND_CALL});
        return args.size() > 1 && "include".equals(((FQN)args.get(0)).getShortName());
    }

    public static boolean isRaiseCall(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            RubyCallTypesCore.$$$reportNull$$$0(0);
        }
        return (callType = call.getCallType()) == RAISE_CALL || callType == FAIL_CALL;
    }

    public static boolean isThrowCall(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            RubyCallTypesCore.$$$reportNull$$$0(1);
        }
        return (callType = call.getCallType()) == THROW_CALL;
    }

    public static boolean isFieldConstructor(@NotNull RCall call) {
        RubyCallType type;
        if (call == null) {
            RubyCallTypesCore.$$$reportNull$$$0(2);
        }
        return (type = call.getCallType()) instanceof RubyAttrCallType || type instanceof StructNewCallType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getDefinedAttributeName(@Nullable PsiElement parameter) {
        if (parameter instanceof ArgumentFakePsiElement) {
            ArgumentFakePsiElement argumentFakePsiElement = (ArgumentFakePsiElement)parameter;
            if (RubyCallTypesCore.isFieldConstructor(argumentFakePsiElement.getCall())) {
                return argumentFakePsiElement.getName();
            }
            return null;
        }
        if (!(parameter instanceof RPsiElement)) {
            return null;
        }
        RCall call = RCallNavigator.getByRArgument(parameter);
        if (call == null) {
            return null;
        }
        if (!RubyCallTypesCore.isFieldConstructor(call)) {
            return null;
        }
        if (parameter instanceof RSymbol) {
            return ((RSymbol)parameter).getName();
        }
        if (parameter instanceof RStringLiteral) {
            RStringLiteral literal = (RStringLiteral)parameter;
            if (call.getCallType() instanceof RubyAttrCallType) {
                if (literal.hasExpressionSubstitutions()) {
                    return null;
                }
                return literal.getContent();
            }
        }
        return null;
    }

    public static boolean isClassName(@NotNull PsiElement element) {
        if (element == null) {
            RubyCallTypesCore.$$$reportNull$$$0(3);
        }
        if (element instanceof StructClassNameFakePsiElement) {
            return true;
        }
        RCall call = RCallNavigator.getByRArgument(element);
        return call != null && call.getCallType() instanceof StructNewCallType && element.equals((Object)call.getCallArguments().getFirstElement()) && element instanceof RStringLiteral;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypesCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRaiseCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isThrowCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

