/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

@Service
public final class RubyCallTypeRegistry
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RubyCallTypeRegistry.class);
    private final MultiMap<String, RubyCallType<?>> myCallTypeMap = new MultiMap();
    private final Map<String, RubyCallType<?>> myPersistentCallTypeMap = new HashMap();
    private int myStubsVersion = 0;

    public static RubyCallTypeRegistry getInstance() {
        return (RubyCallTypeRegistry)ApplicationManager.getApplication().getService(RubyCallTypeRegistry.class);
    }

    public RubyCallTypeRegistry() {
        RubyCallTypeProvider.EP_NAME.addChangeListener(this::collectCallTypesFromExtensions, (Disposable)this);
        this.collectCallTypesFromExtensions();
    }

    private void collectCallTypesFromExtensions() {
        this.myCallTypeMap.clear();
        this.myPersistentCallTypeMap.clear();
        this.myStubsVersion = 0;
        for (RubyCallTypeProvider provider : RubyCallTypeProvider.EP_NAME.getExtensionList()) {
            provider.registerCallTypes(this);
        }
    }

    public int getStubsVersion() {
        return this.myStubsVersion;
    }

    public void dispose() {
    }

    public void registerCallType(RubyCallType<?> type) {
        this.myCallTypeMap.putValue((Object)type.getCommandName(), type);
        if (type.isPersistent()) {
            this.myStubsVersion += type.getStubVersion();
            if (this.myPersistentCallTypeMap.put(type.getUniqueName(), type) != null) {
                throw new IllegalStateException("Duplicate call types: " + type.getUniqueName());
            }
        }
    }

    @Contract(value="null -> false")
    public boolean isPersistentId(@Nullable String id) {
        if (id == null) {
            return false;
        }
        return this.myPersistentCallTypeMap.containsKey(id);
    }

    public void registerCallTypes(RubyCallType<?> ... types) {
        for (RubyCallType<?> callType : types) {
            this.registerCallType(callType);
        }
    }

    @NotNull
    public RubyCallType<?> getCallType(@NotNull String name, @NotNull RPossibleCall rPossibleCall) {
        List compatibleCallTypes;
        if (name == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(0);
        }
        if (rPossibleCall == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(1);
        }
        if (!(compatibleCallTypes = ContainerUtil.filter((Collection)this.myCallTypeMap.get((Object)name), callType -> callType.isCompatible(rPossibleCall))).isEmpty()) {
            RubyCallType callType2 = (RubyCallType)compatibleCallTypes.get(0);
            if (compatibleCallTypes.size() > 1) {
                LOG.warn(String.format("Multiple compatible call types for call '%s', this may result in missing code insight features", callType2.getCommandName()));
            }
            RubyCallType rubyCallType = callType2;
            if (rubyCallType == null) {
                RubyCallTypeRegistry.$$$reportNull$$$0(2);
            }
            return rubyCallType;
        }
        RubyCallType rubyCallType = UnknownRubyCallType.INSTANCE;
        if (rubyCallType == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(3);
        }
        return rubyCallType;
    }

    @NotNull
    public RubyCallType<?> findByPersistentId(@NotNull String uniqueName, @NotNull IElementType elementType) {
        RubyCallType<?> value;
        if (uniqueName == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(4);
        }
        if (elementType == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(5);
        }
        if ((value = this.myPersistentCallTypeMap.get(uniqueName)) == null) {
            LOG.warn("Unable to find call type for [" + uniqueName + "], requested by [" + String.valueOf(elementType.getClass()) + "] scheduling index rebuild");
            StubIndex.getInstance().forceRebuild(new Throwable("Invalid persistent ID " + uniqueName));
            RubyCallType rubyCallType = UnknownRubyCallType.INSTANCE;
            if (rubyCallType == null) {
                RubyCallTypeRegistry.$$$reportNull$$$0(6);
            }
            return rubyCallType;
        }
        RubyCallType<?> rubyCallType = value;
        if (rubyCallType == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(7);
        }
        return rubyCallType;
    }

    public static boolean hasReceiver(@NotNull RPossibleCall call, @NotNull Predicate<RPsiElement> predicate) {
        if (call == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(8);
        }
        if (predicate == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(9);
        }
        if (call instanceof RReference) {
            return predicate.test(call.getReceiver());
        }
        if (call.getPsiCommand() instanceof RReference) {
            return predicate.test(((RReference)call.getPsiCommand()).getReceiver());
        }
        return false;
    }

    public static boolean hasReceiverWithName(@NotNull RPossibleCall call, @NotNull String receiverName) {
        if (call == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(10);
        }
        if (receiverName == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(11);
        }
        return RubyCallTypeRegistry.hasReceiver(call, receiver -> receiver instanceof RConstant && receiverName.equals(receiver.getName()));
    }

    public static boolean hasReceiverWithFqn(@NotNull RPossibleCall call, @NotNull FQN receiverFqn) {
        if (call == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(12);
        }
        if (receiverFqn == null) {
            RubyCallTypeRegistry.$$$reportNull$$$0(13);
        }
        return RubyCallTypeRegistry.hasReceiverWithName(call, receiverFqn.getFullPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPossibleCall";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypeRegistry";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findByPersistentId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findByPersistentId";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasReceiver";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasReceiverWithName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasReceiverWithFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

