/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.psi.reference.PsiOwnSymbolReferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySearchScopeService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPossibleCallElementBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.RIdentifierStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RIdentifierImpl
extends RPossibleCallElementBase<RIdentifierStub>
implements RIdentifier {
    public RIdentifierImpl(ASTNode astNode) {
        super(astNode);
    }

    public RIdentifierImpl(RIdentifierStub stub) {
        super(stub, (IElementType)RubyElementTypes.IDENTIFIER);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RIdentifierImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRIdentifier((RIdentifier)this);
            return;
        }
        super.accept(visitor);
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            RIdentifierImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        String oldName;
        if (newName == null) {
            RIdentifierImpl.$$$reportNull$$$0(2);
        }
        if (Objects.equals(oldName = this.getName(), newName)) {
            return this;
        }
        RIdentifierImpl.checkName(oldName, newName);
        return RubyPsiUtilCore.setElementName((PsiElement)this, newName, null);
    }

    @Nullable
    public ScopeVariable getScopeVariable() {
        RPsiElement realContext = RubyPsiUtilCore.getRealContext((PsiElement)this);
        if (realContext == null) {
            return null;
        }
        Scope scope = ScopeUtilCore.getScope(realContext);
        return scope != null ? scope.getDeclaredVariable((PsiElement)realContext, this.getName()) : null;
    }

    public boolean isLocalVariable() {
        if (this.isParameterDeclaration() || RubyPsiUtilCore.isExplicitCall(this) || RReferenceNavigator.getReferenceByRightPart((PsiElement)this) != null) {
            return false;
        }
        ScopeHolder scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)this);
        while (scopeHolder != null && ScopeUtilCore.hasParentScopeHolder((PsiElement)scopeHolder)) {
            if (ScopeUtilCore.getLocalVariable(scopeHolder, (PsiElement)this, this.getName(), scopeHolder.getVariableDeclarations()) != null) {
                return true;
            }
            scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)scopeHolder);
        }
        if (scopeHolder == null) {
            return false;
        }
        return ScopeUtilCore.getLocalVariable(scopeHolder, (PsiElement)this, this.getName(), scopeHolder.getVariableDeclarations()) != null;
    }

    public boolean isParameterDeclaration() {
        return RubyUsageAnalyzerCore.isParameter(this);
    }

    public boolean isMethodParameterDeclaration() {
        return RubyUsageAnalyzerCore.isMethodParameter(this);
    }

    public boolean isMethodNamedParameter() {
        return RubyUsageAnalyzerCore.isMethodParameter(this) && RubyUsageAnalyzerCore.isNamedParameter(this);
    }

    public boolean isBlockParameterDeclaration() {
        return RubyUsageAnalyzerCore.isBlockParameter(this);
    }

    public boolean isBlockParameter() {
        if (this.isParameterDeclaration()) {
            return false;
        }
        RPsiElement realContext = RubyPsiUtilCore.getRealContext((PsiElement)this);
        if (realContext == null) {
            return false;
        }
        ScopeHolder scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)realContext);
        if (scopeHolder == null) {
            return false;
        }
        PsiElement variable = (PsiElement)ObjectUtils.doIfNotNull((Object)ScopeUtilCore.getScope(realContext), scope -> scope.getLocalVariable((PsiElement)realContext, this.getName()));
        return variable != null && ScopeUtilCore.findScopeHolder(variable) instanceof RCodeBlock;
    }

    public boolean isForLoopVariable() {
        return RubyUsageAnalyzerCore.isForParameter(this);
    }

    public boolean isRescueParameterDeclaration() {
        return RubyUsageAnalyzerCore.isRescueParameter(this);
    }

    public boolean isLambdaParameterDeclaration() {
        return RubyUsageAnalyzerCore.isLambdaParameter(this);
    }

    public boolean isBlockCallLocalDeclaration() {
        return RubyUsageAnalyzerCore.isBlockCallLocalDeclaration(this);
    }

    public boolean isConstructorLike() {
        return "new".equals(this.getText()) && !RIdentifierImpl.isParameterOrLocalVariable((PsiElement)this);
    }

    public boolean isParameter() {
        RIdentifier it;
        PsiElement declaration;
        if (this.isParameterDeclaration() || this.isNumberedParameter()) {
            return true;
        }
        if (RReferenceNavigator.getReferenceByRightPart((PsiElement)this) != null) {
            return false;
        }
        ScopeHolder scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)this);
        while (scopeHolder != null && ScopeUtilCore.hasParentScopeHolder((PsiElement)scopeHolder)) {
            declaration = ScopeUtilCore.getLocalVariable(scopeHolder, (PsiElement)this, this.getName(), scopeHolder.getVariableDeclarations());
            if (declaration instanceof RIdentifier && ((it = (RIdentifier)declaration).isParameterDeclaration() || it.isNumberedParameter())) {
                return true;
            }
            scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)scopeHolder);
        }
        if (scopeHolder == null) {
            return false;
        }
        declaration = ScopeUtilCore.getLocalVariable(scopeHolder, (PsiElement)this, this.getName(), scopeHolder.getVariableDeclarations());
        return declaration instanceof RIdentifier && ((it = (RIdentifier)declaration).isParameterDeclaration() || it.isNumberedParameter());
    }

    public boolean isNumberedParameter() {
        String text = this.getText();
        if (!RIdentifier.isNumberedParameterName((CharSequence)text) || RubyPsiUtilCore.getLanguageLevel((PsiElement)this).isLessThan(LanguageLevel.RUBY27)) {
            return false;
        }
        if ("it".contentEquals(text) && RubyPsiUtilCore.getLanguageLevel((PsiElement)this).isLessThan(LanguageLevel.RUBY34)) {
            return false;
        }
        RPossibleCall command = (RPossibleCall)ObjectUtils.coalesce((Object)RReferenceNavigator.getReferenceByRightPart((PsiElement)this), (Object)((Object)this));
        RPossibleCall call = (RPossibleCall)ObjectUtils.coalesce((Object)RCallNavigator.getByCommand((PsiElement)command), (Object)command);
        if (ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)call), (Object)call) != this) {
            return false;
        }
        Scope scope = ScopeUtilCore.getScope(this);
        RPsiElement scopeElement = ScopeUtilCore.getScopeElement((PsiElement)this);
        if (scope == null || scopeElement == null) {
            return false;
        }
        return ContainerUtil.exists((Iterable)scope.getNumberedParameters((PsiElement)scopeElement), it -> RubyPsiUtilCore.isBefore((PsiElement)it, (PsiElement)this));
    }

    public boolean isNumberedParameterAlias() {
        return this.getText().equals("it") && this.isNumberedParameter();
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isMethodNamedParameter()) {
            SearchScope searchScope = RubySearchScopeService.instance().getProjectAndLibrariesScope(this.getProject());
            if (searchScope == null) {
                RIdentifierImpl.$$$reportNull$$$0(3);
            }
            return searchScope;
        }
        if (this.isParameterDeclaration() || this.isLocalVariable()) {
            return new LocalSearchScope((PsiElement)this.getContainingFile());
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            RIdentifierImpl.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    public Icon getIcon(int flags) {
        if (this.isParameterDeclaration()) {
            return AllIcons.Nodes.Parameter;
        }
        if (this.isLocalVariable()) {
            return AllIcons.Nodes.Variable;
        }
        return super.getIcon(flags);
    }

    public boolean isCall() {
        return !this.isParameter() && !this.isLocalVariable();
    }

    @NotNull
    public PsiElement getPsiCommand() {
        RIdentifierImpl rIdentifierImpl = this;
        if (rIdentifierImpl == null) {
            RIdentifierImpl.$$$reportNull$$$0(5);
        }
        return rIdentifierImpl;
    }

    @NotNull
    public String getCommand() {
        String string = this.getName();
        if (string == null) {
            RIdentifierImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public RPsiElement getReceiver() {
        return RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)this);
    }

    @NotNull
    public List<RPsiElement> getArguments() {
        List<RPsiElement> list = Collections.emptyList();
        if (list == null) {
            RIdentifierImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    protected RubyCallType<?> computeCallType() {
        RubyCallType<?> rubyCallType = RubyCallTypeRegistry.getInstance().getCallType(this.getName(), this);
        if (rubyCallType == null) {
            RIdentifierImpl.$$$reportNull$$$0(8);
        }
        return rubyCallType;
    }

    public PsiElement getNameIdentifier() {
        return this;
    }

    @NotNull
    public Collection<? extends PsiSymbolReference> getOwnReferences() {
        Collection collection = PsiOwnSymbolReferenceProvider.getReferencesOrEmptyCollection((PsiElement)this);
        if (collection == null) {
            RIdentifierImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static void checkName(@NonNls @NotNull String oldName, String newName) throws IncorrectOperationException {
        if (oldName == null) {
            RIdentifierImpl.$$$reportNull$$$0(10);
        }
        if (TextUtil.isAID(oldName) != TextUtil.isAID(newName)) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.cannot.rename.accessor.method.to.common"));
        }
        if (Character.isUpperCase(newName.charAt(0)) || !RubyTextUtil.isCID((String)newName) && !RubyTextUtil.isFID((String)newName)) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.incorrect.name", (Object[])new Object[]{newName}));
        }
    }

    public static boolean isParameterOrLocalVariable(PsiElement element) {
        RIdentifier identifier;
        return element instanceof RIdentifier && ((identifier = (RIdentifier)element).isParameter() || identifier.isLocalVariable());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/variables/RIdentifierImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/variables/RIdentifierImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCallType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

