/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.REmptyListOfExpressionsImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPossibleCallElementBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;

public abstract class RPossibleCallImpl<StubType extends RPossibleCallStub<? extends RCall>>
extends RPossibleCallElementBase<StubType>
implements RPsiElement,
RCall,
StubBasedPsiElement<StubType> {
    public RPossibleCallImpl(StubType stub, IElementType nodeType) {
        super(stub, nodeType);
    }

    public RPossibleCallImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected RubyCallType<?> computeCallType() {
        RubyCallType type;
        PsiElement commandElement = this.getPsiCommand();
        if (commandElement instanceof RReference) {
            RReference reference = (RReference)commandElement;
            String command = reference.getCommand();
            if (command == null) {
                RubyCallType rubyCallType = UnknownRubyCallType.INSTANCE;
                if (rubyCallType == null) {
                    RPossibleCallImpl.$$$reportNull$$$0(0);
                }
                return rubyCallType;
            }
            type = RubyCallTypeRegistry.getInstance().getCallType(command, this);
        } else {
            type = RubyCallTypeRegistry.getInstance().getCallType(commandElement.getText(), this);
        }
        RubyCallType rubyCallType = !(this instanceof RArrayIndexing) || type.canBeArrayIndexing() ? type : UnknownRubyCallType.INSTANCE;
        if (rubyCallType == null) {
            RPossibleCallImpl.$$$reportNull$$$0(1);
        }
        return rubyCallType;
    }

    @NotNull
    public PsiElement getPsiCommand() {
        RPsiElement command = (RPsiElement)PsiTreeUtil.getChildOfType((PsiElement)this, RPsiElement.class);
        if (command == null) {
            PsiElement cmd = this.getFirstChild();
            if (cmd != null && cmd.getNode().getElementType() == RubyTokenTypes.kSUPER) {
                PsiElement psiElement = cmd;
                if (psiElement == null) {
                    RPossibleCallImpl.$$$reportNull$$$0(2);
                }
                return psiElement;
            }
            throw new IllegalStateException(String.format("Cannot find command in call '%s'", this.getText()));
        }
        RPsiElement rPsiElement = command;
        if (rPsiElement == null) {
            RPossibleCallImpl.$$$reportNull$$$0(3);
        }
        return rPsiElement;
    }

    @NotNull
    public RListOfExpressions getCallArguments() {
        RListOfExpressions arguments = (RListOfExpressions)PsiTreeUtil.getChildOfType((PsiElement)this, RListOfExpressions.class);
        return arguments != null ? arguments : new REmptyListOfExpressionsImpl(this);
    }

    @NotNull
    public String getCommand() {
        RPossibleCallStub callStub = (RPossibleCallStub)this.getStub();
        if (callStub != null && callStub.getCallData().getCallType() != UnknownRubyCallType.INSTANCE) {
            String string = callStub.getCommand();
            if (string == null) {
                RPossibleCallImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.getPsiCommand().getText();
        if (string == null) {
            RPossibleCallImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isCall() {
        return true;
    }

    @NotNull
    public List<RPsiElement> getArguments() {
        List list = this.getCallArguments().getElements();
        if (list == null) {
            RPossibleCallImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/methodCall/RPossibleCallImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCallType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiCommand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

