/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallTypeKt;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RMethodStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class RMethodImpl
extends RMethodBase<RMethodStub>
implements RMethod,
StubBasedPsiElement<RMethodStub> {
    public RMethodImpl(ASTNode astNode) {
        super(astNode);
    }

    public RMethodImpl(RMethodStub rMethodStub) {
        super(rMethodStub, RubyElementTypes.METHOD);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RMethodImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRMethod((RMethod)this);
            return;
        }
        super.accept(visitor);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getMethodName();
    }

    public boolean isConstructor() {
        return FQN.same((FQN)this.getFQN(), (String)"initialize");
    }

    public int getOriginalTextOffset() {
        return super.getTextOffset();
    }

    public int getTextOffset() {
        PsiElement name = this.getNameIdentifier();
        return name != null ? name.getTextOffset() : this.getOriginalTextOffset();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        RName rName;
        if (name == null) {
            RMethodImpl.$$$reportNull$$$0(1);
        }
        if ((rName = this.getMethodName()) == null) {
            return this;
        }
        if (TextUtil.isAID(this.getName()) != TextUtil.isAID(name)) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.cannot.rename.accessor.method.to.common"));
        }
        if (!(RubyTextUtil.isCID((String)name) || RubyTextUtil.isFID((String)name) || TextUtil.isAID(name))) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.incorrect.name", (Object[])new Object[]{name}));
        }
        rName.setName(name);
        return this;
    }

    @Override
    public RPsiElement getNameElement() {
        return this.getMethodName();
    }

    @NotNull
    public Visibility getVisibility() {
        RMethodStub stub = (RMethodStub)this.getGreenStub();
        if (stub != null) {
            Visibility visibility = stub.getVisibility();
            if (visibility == null) {
                RMethodImpl.$$$reportNull$$$0(2);
            }
            return visibility;
        }
        RPsiElement parentNamespace = Optional.ofNullable(RubyPsiUtilCore.getParentNamespace((PsiElement)this)).orElseGet(() -> (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)this, RFile.class));
        Map visibilityMapping = parentNamespace != null ? (Map)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)ObjectUtils.chooseNotNull((Object)parentNamespace, (Object)this)), () -> RMethodImpl.computeVisibilities(parentNamespace)) : Collections.emptyMap();
        Visibility visibility = (Visibility)ObjectUtils.chooseNotNull((Object)((Visibility)visibilityMapping.get(this)), (Object)Visibility.PUBLIC);
        if (visibility == null) {
            RMethodImpl.$$$reportNull$$$0(3);
        }
        return visibility;
    }

    @NotNull
    private static CachedValueProvider.Result<Map<PsiElement, Visibility>> computeVisibilities(@NotNull RPsiElement container) {
        if (container == null) {
            RMethodImpl.$$$reportNull$$$0(4);
        }
        final Ref scopeVisibility = new Ref((Object)(container instanceof RFile ? Visibility.PRIVATE : Visibility.PUBLIC));
        final MultiMap methodsMap = new MultiMap();
        final HashMap ans = new HashMap();
        RubyRecursiveElementVisitor myVisitor = new RubyRecursiveElementVisitor(){

            public void visitRModule(@NotNull RModule rModule) {
                if (rModule == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void visitRClass(@NotNull RClass rClass) {
                if (rClass == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void visitRObjectClass(@NotNull RObjectClass rMetaClass) {
                if (rMetaClass == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
                if (assignmentExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            public void visitRMethod(@NotNull RMethod rMethod) {
                if (rMethod == null) {
                    1.$$$reportNull$$$0(4);
                }
                ans.put(rMethod, (Visibility)scopeVisibility.get());
                methodsMap.putValue((Object)rMethod.getName(), (Object)((RMethodImpl)rMethod));
            }

            public void visitRBlockCall(@NotNull RBlockCall blockCall) {
                if (blockCall == null) {
                    1.$$$reportNull$$$0(5);
                }
            }

            public void visitRCall(@NotNull RCall rCall) {
                RubyCallType type;
                if (rCall == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((type = rCall.getCallType()) instanceof RubyVisibilityCallType) {
                    RubyVisibilityCallType visibilityCallType = (RubyVisibilityCallType)type;
                    Visibility visibility = visibilityCallType.getVisibility();
                    for (String arg : (List)rCall.getData(new RubyCallType[]{visibilityCallType})) {
                        RPsiElement first;
                        if (RubyVisibilityCallTypeKt.isMethodArg((String)arg) && (first = (RPsiElement)ContainerUtil.getFirstItem((List)rCall.getArguments())) instanceof RMethodImpl) {
                            this.visitRMethod((RMethodImpl)first);
                            ans.put(first, visibility);
                            break;
                        }
                        if (!methodsMap.containsKey((Object)arg)) continue;
                        for (RMethodImpl method : methodsMap.get((Object)arg)) {
                            ans.put(method, visibility);
                        }
                    }
                }
            }

            public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
                if (rIdentifier == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (VisibilityUtilCore.isVisibilityChangeCall(rIdentifier.getNode())) {
                    Visibility value = VisibilityUtilCore.getVisibility(rIdentifier.getText());
                    assert (value != null) : "Scope visibility cannot be null here";
                    scopeVisibility.set((Object)value);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rModule";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rMetaClass";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentExpression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rMethod";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "blockCall";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rCall";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rIdentifier";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RMethodImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRModule";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRObjectClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRAssignmentExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRMethod";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRBlockCall";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRCall";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIdentifier";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        container.acceptChildren((PsiElementVisitor)myVisitor);
        CachedValueProvider.Result result = CachedValueProvider.Result.create(ans, (Object[])new Object[]{container});
        if (result == null) {
            RMethodImpl.$$$reportNull$$$0(5);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RMethodImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RMethodImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVisibilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeVisibilities";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

