/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiElementBaseImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RStatementsProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public class RCompoundStatementImpl
extends RPsiElementBaseImpl
implements RCompoundStatement {
    private List<RPsiElement> myStatements = null;

    public RCompoundStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRCompoundStatement((RCompoundStatement)this);
            return;
        }
        super.accept(visitor);
    }

    @NotNull
    public List<RPsiElement> getStatements() {
        if (this.myStatements == null) {
            this.myStatements = this.getMyStatements();
        }
        List<RPsiElement> list = this.myStatements;
        if (list == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    private List<RPsiElement> getMyStatements() {
        LinkedList<RPsiElement> statements = new LinkedList<RPsiElement>();
        statements.addAll(RubyPsiUtilCore.getChildrenByFilter((PsiElement)this, RPsiElement.class));
        for (RStatementsProvider provider : RubyPsiUtilCore.getChildrenByFilter((PsiElement)this, RStatementsProvider.class)) {
            statements.addAll(provider.findStatements());
        }
        return statements;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.clearCaches();
    }

    private void clearCaches() {
        this.myStatements = null;
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                RCompoundStatementImpl.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        while (psiChild != null) {
            ASTNode node = psiChild.getNode();
            if (node instanceof CompositeElement || node instanceof OuterLanguageElement) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(4);
        }
        if (!(element instanceof RMethod)) {
            return super.add(element);
        }
        for (RPsiElement statement : this.getStatements()) {
            if (!(statement instanceof RIdentifier) || !(((RIdentifier)statement).getCallType() instanceof RubyVisibilityCallType)) continue;
            return this.addBefore(element, (PsiElement)statement);
        }
        return super.add(element);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(5);
        }
        return this.addChild(element, anchor, true);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(6);
        }
        return this.addChild(element, anchor, false);
    }

    public void removeStatement(PsiElement psiElement) {
        assert (psiElement.getParent() == this && psiElement instanceof RPsiElement);
        PsiElement prevSibling = RubyPsiUtilCore.getPrevSignificantSibling(psiElement);
        if (prevSibling != null && !RubySpaceUtil.isEol((PsiElement)prevSibling)) {
            prevSibling = prevSibling.getNextSibling();
        }
        if (prevSibling == null) {
            prevSibling = psiElement;
        }
        psiElement.getParent().deleteChildRange(prevSibling, psiElement);
    }

    @NotNull
    public String getName() {
        String name;
        PsiNamedElement parentNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)this, PsiNamedElement.class);
        if (parentNamedElement != null && (name = parentNamedElement.getName()) != null) {
            String string = name;
            if (string == null) {
                RCompoundStatementImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "";
    }

    public boolean isValidHost() {
        return TemplateLanguageUtil.isInsideTemplateFile((PsiElement)this);
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(8);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new LiteralTextEscaper<RCompoundStatementImpl>(this, this){

            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outChars == null) {
                    1.$$$reportNull$$$0(1);
                }
                outChars.append(rangeInsideHost.substring(((RCompoundStatementImpl)this.myHost).getText()));
                return true;
            }

            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(2);
                }
                return rangeInsideHost.getStartOffset() + offsetInDecoded;
            }

            public boolean isOneLine() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeInsideHost";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outChars";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/blocks/RCompoundStatementImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "decode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getOffsetInHost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private PsiElement addChild(@NotNull PsiElement element, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        Language theLanguage;
        if (element == null) {
            RCompoundStatementImpl.$$$reportNull$$$0(9);
        }
        BiFunction<PsiElement, PsiElement, PsiElement> adder = (e, a) -> before ? super.addBefore(e, a) : super.addAfter(e, a);
        if (anchor == null) {
            return adder.apply(element, null);
        }
        PsiFile containingFile = anchor.getContainingFile();
        if (containingFile == null) {
            return adder.apply(element, anchor);
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        Set languages = viewProvider.getLanguages();
        if (languages.size() == 1 && (theLanguage = (Language)languages.iterator().next()) == RubyLanguage.INSTANCE) {
            return adder.apply(element, anchor);
        }
        PsiFile erbPsiFile = viewProvider.getPsi((Language)ErbLanguage.INSTANCE);
        if (languages.size() == 2 && erbPsiFile != null) {
            return adder.apply(element, anchor);
        }
        PsiElement newElement = TemplateIntegrationUtils.getInstance().addRubyStatement(viewProvider, this, element, anchor, before);
        if (newElement != null) {
            return newElement;
        }
        return adder.apply(element, anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/blocks/RCompoundStatementImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/blocks/RCompoundStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7 -> new IllegalStateException(string);
        };
    }
}

