/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.heredocs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyHeredocUtil;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiElementBaseImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class RHeredocIdImpl
extends RPsiElementBaseImpl
implements RHeredocId {
    public RHeredocIdImpl(ASTNode astNode) {
        super(astNode);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RHeredocIdImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRHeredocId((RHeredocId)this);
            return;
        }
        super.accept(visitor);
    }

    @Nullable
    public RHeredocValue getHeredocValue() {
        String myId = this.getId();
        RHeredocIdImpl anchor = this;
        RPsiElement statement = RubyPsiUtilCore.getStatement((PsiElement)this);
        RHeredocValue value;
        while ((value = RHeredocIdImpl.getHeredocByAnchor(myId, (PsiElement)anchor)) == null) {
            if (anchor == null || anchor == statement) {
                return null;
            }
            anchor = anchor.getParent();
        }
        return value;
    }

    @Nullable
    public PsiElement getHeredocEnd() {
        PsiElement element = (PsiElement)ObjectUtils.doIfNotNull((Object)this.getHeredocValue(), PsiElement::getNextSibling);
        while (RubySpaceUtil.isAnySpace((PsiElement)element)) {
            element = element.getNextSibling();
        }
        if (TokenBNF.tHEREDOC_ENDS.contains(PsiUtilCore.getElementType((PsiElement)element))) {
            return element;
        }
        return null;
    }

    @Nullable
    private static RHeredocValue getHeredocByAnchor(String myId, PsiElement anchor) {
        PsiElement element = anchor;
        if (anchor instanceof RBlockCall) {
            RCodeBlock codeBlock = ((RBlockCall)anchor).getBlock();
            PsiElement child = PsiTreeUtil.getChildOfType((PsiElement)codeBlock, RHeredocValue.class);
            if (child == null) {
                child = codeBlock.getCompoundStatement().getFirstChild();
            }
            if (child instanceof RHeredocValue) {
                return (RHeredocValue)child;
            }
        }
        while (element != null) {
            String id;
            RHeredocValue heredocValue = (RHeredocValue)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, RHeredocValue.class);
            if (heredocValue != null && ((id = heredocValue.getId()) == null || myId.equals(id))) {
                return heredocValue;
            }
            element = heredocValue;
        }
        return null;
    }

    @NotNull
    public String getId() {
        String string = RubyHeredocUtil.getName((String)this.getText());
        if (string == null) {
            RHeredocIdImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getIdPrefix() {
        String text = this.getText();
        if (text.startsWith("<<-")) {
            return "<<-";
        }
        if (text.startsWith("<<~")) {
            return "<<~";
        }
        return "<<";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/heredocs/RHeredocIdImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/heredocs/RHeredocIdImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

