/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;

public class RStringLiteralBaseEscaper
extends LiteralTextEscaper<RStringLiteralBase> {
    private int[] myOutSourceOffsets;

    protected RStringLiteralBaseEscaper(@NotNull RStringLiteralBase host) {
        if (host == null) {
            RStringLiteralBaseEscaper.$$$reportNull$$$0(0);
        }
        super((PsiLanguageInjectionHost)host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            RStringLiteralBaseEscaper.$$$reportNull$$$0(1);
        }
        if (outChars == null) {
            RStringLiteralBaseEscaper.$$$reportNull$$$0(2);
        }
        String text = ((RStringLiteralBase)this.myHost).getText();
        this.myOutSourceOffsets = new int[text.length() + 1];
        Arrays.fill(this.myOutSourceOffsets, -1);
        int offset = 0;
        for (TextRange range : ContainerUtil.mapNotNull((Collection)((RStringLiteralBase)this.myHost).getContentRanges(), it -> it.intersection(rangeInsideHost))) {
            String subtext = range.substring(text);
            if (subtext.isEmpty()) continue;
            String convertedText = RubyTextUtil.convertEmojiCodesToPics((String)subtext);
            for (int i = 0; i < convertedText.length(); ++i) {
                Pair<Character, Integer> unescapedCharacterAndNewOffset;
                char c = convertedText.charAt(i);
                if (c == '\\' && i == convertedText.length() - 1) {
                    return false;
                }
                this.myOutSourceOffsets[offset++] = i + (range.getStartOffset() - rangeInsideHost.getStartOffset());
                if (c == '\\' && (unescapedCharacterAndNewOffset = this.unescapeCharacter(convertedText, i + 1)) != null) {
                    c = ((Character)unescapedCharacterAndNewOffset.first).charValue();
                    i = (Integer)unescapedCharacterAndNewOffset.second;
                }
                outChars.append(c);
            }
            this.myOutSourceOffsets[offset] = range.getEndOffset() - rangeInsideHost.getStartOffset();
        }
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        if (rangeInsideHost == null) {
            RStringLiteralBaseEscaper.$$$reportNull$$$0(3);
        }
        int offset = offsetInDecoded < this.myOutSourceOffsets.length ? this.myOutSourceOffsets[offsetInDecoded] : -1;
        return offset >= 0 ? Math.min(offset, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset() : -1;
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        TextRange textRange = TextRangeUtil.getEnclosingTextRange((List)((RStringLiteralBase)this.myHost).getContentRanges());
        if (textRange == null) {
            RStringLiteralBaseEscaper.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public boolean isOneLine() {
        return !(this.myHost instanceof RDStringLiteralImpl) && !(this.myHost instanceof RHeredocValue);
    }

    @Nullable
    protected Pair<Character, Integer> unescapeCharacter(@NotNull String text, int offset) {
        char c;
        if (text == null) {
            RStringLiteralBaseEscaper.$$$reportNull$$$0(5);
        }
        if ((c = text.charAt(offset)) == 'n') {
            return new Pair((Object)Character.valueOf('\n'), (Object)offset);
        }
        if (c == 't') {
            return new Pair((Object)Character.valueOf('\t'), (Object)offset);
        }
        if (c == 'r') {
            return new Pair((Object)Character.valueOf('\r'), (Object)offset);
        }
        if (c == 'f') {
            return new Pair((Object)Character.valueOf('\f'), (Object)offset);
        }
        if (c == '\\') {
            return new Pair((Object)Character.valueOf('\\'), (Object)offset);
        }
        if (Character.isDigit(c) && offset < text.length() - 2) {
            if (Character.isDigit(text.charAt(offset + 1)) && Character.isDigit(text.charAt(offset + 2))) {
                return new Pair((Object)Character.valueOf((char)Integer.parseInt(text.substring(offset, offset + 3), 16)), (Object)(offset + 2));
            }
            if (c == '0') {
                return new Pair((Object)Character.valueOf('0'), (Object)offset);
            }
        }
        return new Pair((Object)Character.valueOf(c), (Object)offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/RStringLiteralBaseEscaper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/RStringLiteralBaseEscaper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInHost";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unescapeCharacter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

