/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyPsiElementWithReferences;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBaseEscaper;

public class RStringLiteralBase
extends RubyPsiElementWithReferences
implements RStringLiteral,
RExpression,
PsiLanguageInjectionHost {
    public RStringLiteralBase(ASTNode astNode) {
        super(astNode);
    }

    public String getContent() {
        StringBuilder builder = new StringBuilder();
        List<PsiElement> list = this.getPsiContent();
        for (PsiElement e : list) {
            builder.append(e.getText());
        }
        return builder.toString();
    }

    @NotNull
    public String getContentValue() {
        List<PsiElement> list = this.getPsiContent();
        if (list.isEmpty()) {
            return "";
        }
        PsiElement lastElement = list.get(list.size() - 1);
        TextRange contentRangeInLiteral = TextRange.create((int)list.get(0).getStartOffsetInParent(), (int)(lastElement.getStartOffsetInParent() + lastElement.getTextLength()));
        StringBuilder result = new StringBuilder();
        this.createLiteralTextEscaper().decode(contentRangeInLiteral, result);
        String string = result.toString();
        if (string == null) {
            RStringLiteralBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean hasExpressionSubstitutions() {
        return !this.getExpressionSubstitutions().isEmpty();
    }

    public List<RExpressionSubstitution> getExpressionSubstitutions() {
        List<PsiElement> list = RubyPsiUtilCore.getChildrenByFilter((PsiElement)this, RubyElementTypes.EXPR_SUBTITUTION);
        LinkedList<RExpressionSubstitution> exprList = new LinkedList<RExpressionSubstitution>();
        for (PsiElement e : list) {
            exprList.add((RExpressionSubstitution)e);
        }
        return exprList;
    }

    public List<PsiElement> getPsiContent() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (ASTNode node : this.getNode().getChildren(null)) {
            IElementType type = node.getElementType();
            if (this.isBeginning(type)) continue;
            if (this.isEnding(type)) break;
            result.add(node.getPsi());
        }
        return result;
    }

    protected boolean isBeginning(@Nullable IElementType type) {
        return TokenBNF.tSTRINGS_BEGINNINGS.contains(type);
    }

    protected boolean isEnding(@Nullable IElementType type) {
        return RubyTokenTypes.tSTRING_END == type;
    }

    @Nullable
    public PsiElement getStringBeginning() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null && this.isBeginning(firstChild.getNode().getElementType())) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getStringEnding() {
        PsiElement closingElement = this.getLastChild();
        if (closingElement != null && this.isEnding(closingElement.getNode().getElementType())) {
            return closingElement;
        }
        return null;
    }

    public boolean isValidHost() {
        return false;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            RStringLiteralBase.$$$reportNull$$$0(1);
        }
        String left = (String)ObjectUtils.coalesce((Object)((String)ObjectUtils.doIfNotNull((Object)this.getStringBeginning(), PsiElement::getText)), (Object)"");
        String right = (String)ObjectUtils.coalesce((Object)((String)ObjectUtils.doIfNotNull((Object)this.getStringEnding(), PsiElement::getText)), (Object)"");
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)StringUtil.trimStart((String)StringUtil.trimEnd((String)text, (String)right), (String)left));
    }

    public char @NotNull [] getCharsThatMustBeEscaped() {
        char[] cArray = new char[]{'\\'};
        if (cArray == null) {
            RStringLiteralBase.$$$reportNull$$$0(2);
        }
        return cArray;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new RStringLiteralBaseEscaper(this);
    }

    public boolean supportsInterpolation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/RStringLiteralBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/RStringLiteralBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsThatMustBeEscaped";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

