/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RBaseStringImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;

public final class RNameUtilCore {
    private RNameUtilCore() {
    }

    @NotNull
    private static List<? extends PsiElement> getPsiPathRec(@Nullable PsiElement element) {
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RNameUtilCore.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiElement firstChild = element.getFirstChild();
        if (element instanceof RName) {
            if (element.getParent() instanceof RMethod) {
                List result = RNameUtilCore.getPsiPathRec(firstChild);
                PsiElement lastChild = element.getLastChild();
                if (firstChild != lastChild) {
                    result = ContainerUtil.concat(result, RNameUtilCore.getPsiPathRec(lastChild));
                }
                List list = result;
                if (list == null) {
                    RNameUtilCore.$$$reportNull$$$0(1);
                }
                return list;
            }
            return RNameUtilCore.getPsiPathRec(firstChild);
        }
        if (element instanceof RClassObject) {
            return RNameUtilCore.getPsiPathRec((PsiElement)((RClassObject)element).getExpression());
        }
        if (element instanceof RGroupedExpression) {
            return RNameUtilCore.getPsiPathRec((PsiElement)((RGroupedExpression)element).getExpression());
        }
        if (element instanceof RReference) {
            RReference ref = (RReference)element;
            List list = ContainerUtil.concat(RNameUtilCore.getPsiPathRec((PsiElement)ref.getReceiver()), RNameUtilCore.getPsiPathRec((PsiElement)ref.getValue()));
            if (list == null) {
                RNameUtilCore.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (element instanceof RTopConstReference) {
            List<RConstant> list = Collections.singletonList(((RTopConstReference)element).getConstant());
            if (list == null) {
                RNameUtilCore.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (element instanceof RSymbol) {
            return RNameUtilCore.getPsiPathRec(((RSymbol)element).getContent());
        }
        if (element instanceof RStringLiteral && !((RStringLiteral)element).hasExpressionSubstitutions()) {
            List list = ((RStringLiteral)element).getPsiContent();
            if (list == null) {
                RNameUtilCore.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<PsiElement> list = Collections.singletonList(element);
        if (list == null) {
            RNameUtilCore.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static FQN getPath(@Nullable PsiElement element) {
        return RNameUtilCore.createFQN(element, false);
    }

    @NotNull
    public static FQN createFQN(@Nullable PsiElement element, boolean forceConstant) {
        StringBuilder sb = new StringBuilder();
        for (PsiElement psiElement : RNameUtilCore.getPsiPathRec(element)) {
            if (!sb.isEmpty()) {
                sb.append(RNameUtilCore.isDot(psiElement.getPrevSibling()) ? "." : "::");
            }
            if (psiElement.getParent() instanceof RTopConstReference) {
                sb.append("::");
            }
            sb.append(psiElement.getText());
        }
        String fqnAsString = sb.toString();
        if (fqnAsString.isEmpty() || fqnAsString.equals("::")) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RNameUtilCore.$$$reportNull$$$0(6);
            }
            return fQN;
        }
        if (forceConstant) {
            List<String> list = Collections.singletonList(StringUtil.trimStart((String)fqnAsString, (String)"::"));
            FQN fQN = FQN.Builder.create(list, (boolean)fqnAsString.startsWith("::"));
            if (fQN == null) {
                RNameUtilCore.$$$reportNull$$$0(7);
            }
            return fQN;
        }
        FQN fQN = FQN.Builder.fromString((String)fqnAsString);
        if (fQN == null) {
            RNameUtilCore.$$$reportNull$$$0(8);
        }
        return fQN;
    }

    private static boolean isDot(PsiElement sibling) {
        return sibling instanceof LeafPsiElement && ((LeafPsiElement)sibling).getElementType() == RubyTokenTypes.tDOT;
    }

    @Nullable
    public static PsiElement rename(PsiElement element, @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            RNameUtilCore.$$$reportNull$$$0(9);
        }
        if (element instanceof RBaseStringImpl) {
            return ((RBaseStringImpl)element).setName(newName);
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).setName(newName);
        }
        if (element instanceof RFName) {
            return ((RFName)element).setName(newName);
        }
        return null;
    }

    public static boolean matchesFQN(String fqn, String locationFqn, @Nullable RContainer context, String referenceText) {
        String contextFqn;
        if (referenceText.startsWith("::")) {
            return fqn.equals(referenceText.substring(2));
        }
        String string = contextFqn = context == null || context instanceof RFile ? "" : context.getFQNWithNesting().getFullPath();
        if (contextFqn.startsWith(locationFqn)) {
            return true;
        }
        return fqn.equals(StringUtil.isEmpty((String)contextFqn) ? referenceText : contextFqn + "::" + referenceText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RNameUtilCore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiPathRec";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFQN";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RNameUtilCore";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 9 -> new IllegalArgumentException(string);
        };
    }
}

