/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;

public class RControlFlowImpl
implements RControlFlow {
    private final Instruction[] myInstructions;
    private final NotNullLazyValue<Map<PsiElement, Instruction>> myElementInstructionMap;
    private final NotNullLazyValue<BitSet> myReachabilityProvider;

    public RControlFlowImpl(Instruction @NotNull [] instructions) {
        if (instructions == null) {
            RControlFlowImpl.$$$reportNull$$$0(0);
        }
        this.myElementInstructionMap = NotNullLazyValue.atomicLazy(this::computeElementInstructionsMap);
        this.myReachabilityProvider = NotNullLazyValue.atomicLazy(this::calculateReachable);
        this.myInstructions = instructions;
    }

    @NotNull
    private Map<PsiElement, Instruction> computeElementInstructionsMap() {
        HashMap<PsiElement, Instruction> result = new HashMap<PsiElement, Instruction>();
        for (Instruction instruction : this.myInstructions) {
            PsiElement element = instruction.getElement();
            if (element == null) continue;
            result.put(element, instruction);
        }
        HashMap<PsiElement, Instruction> hashMap = result;
        if (hashMap == null) {
            RControlFlowImpl.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    public Instruction @NotNull [] getInstructions() {
        if (this.myInstructions == null) {
            RControlFlowImpl.$$$reportNull$$$0(2);
        }
        return this.myInstructions;
    }

    @Nullable
    public Instruction getInstructionByElement(@NotNull PsiElement element) {
        if (element == null) {
            RControlFlowImpl.$$$reportNull$$$0(3);
        }
        return ((Map)this.myElementInstructionMap.getValue()).getOrDefault(element, null);
    }

    public boolean isReachable(@NotNull Instruction instruction) {
        if (instruction == null) {
            RControlFlowImpl.$$$reportNull$$$0(4);
        }
        if (instruction != this.myInstructions[instruction.num()]) {
            throw new IllegalArgumentException("Instruction is not from RControlFlow");
        }
        return ((BitSet)this.myReachabilityProvider.getValue()).get(instruction.num());
    }

    @NotNull
    private BitSet calculateReachable() {
        BitSet reachable = new BitSet(this.myInstructions.length);
        ControlFlowUtil.process((Instruction[])this.myInstructions, (int)0, instruction -> {
            reachable.set(instruction.num());
            return true;
        });
        BitSet bitSet = reachable;
        if (bitSet == null) {
            RControlFlowImpl.$$$reportNull$$$0(5);
        }
        return bitSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/impl/RControlFlowImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/impl/RControlFlowImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeElementInstructionsMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReachable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstructionByElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReachable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

