/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public final class RControlFlowUtil {
    @NotNull
    public static final NotNullLazyValue<RControlFlow> TOO_BIG_FLOW_PROVIDER = NotNullLazyValue.lazy(() -> new RControlFlowImpl(RControlFlowUtil.createEmptyCfgInstructions()){

        public boolean isTooBig() {
            return true;
        }
    });
    @NotNull
    public static final NotNullLazyValue<RControlFlow> INVALID_INSTRUCTION_BLOCK_FLOW_PROVIDER = NotNullLazyValue.lazy(() -> new RControlFlowImpl(RControlFlowUtil.createEmptyCfgInstructions()));

    private RControlFlowUtil() {
    }

    public static Collection<PsiElement> findExitPointsAndStatements(ControlFlow flow) {
        ArrayList<PsiElement> statements = new ArrayList<PsiElement>();
        for (Instruction exitPoint : RControlFlowUtil.findExitInstructions(flow)) {
            PsiElement booleanExpression;
            RPsiElement statement = RubyPsiUtilCore.getStatement(exitPoint.getElement());
            if (statement == null || (booleanExpression = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{RBoolBinExpression.class, RBoolNegExpression.class})) != null && PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)booleanExpression, (boolean)false)) continue;
            statements.add((PsiElement)statement);
        }
        return statements;
    }

    public static List<Instruction> findExitInstructions(ControlFlow flow) {
        Instruction lastInstruction;
        Instruction[] instructions = flow.getInstructions();
        List exitInstructions = ContainerUtil.filter(RControlFlowUtil.collectPredecessorsWithoutCompoundAndBlockStatements(instructions, lastInstruction = instructions[instructions.length - 1], true), it -> it.getElement() != null && !RubyUsageAnalyzerCore.isParameter((RPsiElement)it.getElement()));
        if (exitInstructions.isEmpty()) {
            return Collections.singletonList(instructions[instructions.length - 2]);
        }
        return exitInstructions;
    }

    @NotNull
    public static Collection<Instruction> collectPredecessorsWithoutCompoundAndBlockStatements(Instruction @NotNull [] instructions, @NotNull Instruction instruction) {
        if (instruction == null) {
            RControlFlowUtil.$$$reportNull$$$0(0);
        }
        if (instructions == null) {
            RControlFlowUtil.$$$reportNull$$$0(1);
        }
        return RControlFlowUtil.collectPredecessorsWithoutCompoundAndBlockStatements(instructions, instruction, false);
    }

    @NotNull
    public static Collection<Instruction> collectPredecessorsWithoutCompoundAndBlockStatements(Instruction @NotNull [] instructions, @NotNull Instruction instruction, boolean passThroughFirst) {
        if (instruction == null) {
            RControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (instructions == null) {
            RControlFlowUtil.$$$reportNull$$$0(3);
        }
        ArrayList<Instruction> noCompoundAndBlockInstructions = new ArrayList<Instruction>();
        ControlFlowUtil.iteratePrev((int)instruction.num(), (Instruction[])instructions, currentInstruction -> {
            PsiElement element = currentInstruction.getElement();
            if (element instanceof RCompoundStatement || element instanceof RBlockStatement) {
                return ControlFlowUtil.Operation.NEXT;
            }
            if (passThroughFirst && element == null && currentInstruction == instruction) {
                return ControlFlowUtil.Operation.NEXT;
            }
            noCompoundAndBlockInstructions.add((Instruction)currentInstruction);
            return ControlFlowUtil.Operation.CONTINUE;
        });
        ArrayList<Instruction> arrayList = noCompoundAndBlockInstructions;
        if (arrayList == null) {
            RControlFlowUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static Graph<Instruction> getGraphWithoutRBlockCall(@NotNull RControlFlow controlFlow) {
        if (controlFlow == null) {
            RControlFlowUtil.$$$reportNull$$$0(5);
        }
        if (controlFlow.isTooBig()) {
            Graph graph = InstructionGraphUtilCore.TOO_BIG_GRAPH;
            if (graph == null) {
                RControlFlowUtil.$$$reportNull$$$0(6);
            }
            return graph;
        }
        Instruction @NotNull [] flow = controlFlow.getInstructions();
        LongOpenHashSet removedEdges = new LongOpenHashSet();
        final Instruction entry = flow[0];
        for (Instruction instruction : flow) {
            Collection allSuccessors = instruction.allSucc();
            Instruction blockCallInstruction = null;
            for (Instruction successor : allSuccessors) {
                if (!(successor.getElement() instanceof RBlockCall)) continue;
                blockCallInstruction = successor;
                break;
            }
            if (blockCallInstruction == null) continue;
            for (Instruction successor : allSuccessors) {
                if (successor == blockCallInstruction) continue;
                removedEdges.add(RControlFlowUtil.getEdgeNum(instruction, successor));
            }
        }
        return new Graph<Instruction>((LongSet)removedEdges){
            private Set<Instruction> myNodes;
            final /* synthetic */ LongSet val$removedEdges;
            {
                this.val$removedEdges = longSet;
            }

            @NotNull
            public Collection<Instruction> getNodes() {
                if (this.myNodes == null) {
                    LinkedHashSet<Instruction> nodes = new LinkedHashSet<Instruction>();
                    GraphAlgorithms.getInstance().collectOutsRecursively((Graph)this, (Object)entry, nodes);
                    this.myNodes = nodes;
                }
                Set<Instruction> set = this.myNodes;
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set;
            }

            @NotNull
            public Iterator<Instruction> getIn(Instruction n) {
                Iterator iterator = ContainerUtil.filterIterator(n.allPred().iterator(), it -> this.hasEdge((Instruction)it, n));
                if (iterator == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            @NotNull
            public Iterator<Instruction> getOut(Instruction n) {
                Iterator iterator = ContainerUtil.filterIterator(n.allSucc().iterator(), it -> this.hasEdge(n, (Instruction)it));
                if (iterator == null) {
                    2.$$$reportNull$$$0(2);
                }
                return iterator;
            }

            private boolean hasEdge(Instruction from, Instruction to) {
                return !this.val$removedEdges.contains(RControlFlowUtil.getEdgeNum(from, to)) && (this.myNodes == null || this.myNodes.contains(from) && this.myNodes.contains(to));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/RControlFlowUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static long getEdgeNum(@NotNull Instruction from, @NotNull Instruction to) {
        if (from == null) {
            RControlFlowUtil.$$$reportNull$$$0(7);
        }
        if (to == null) {
            RControlFlowUtil.$$$reportNull$$$0(8);
        }
        return (long)from.num() | (long)to.num() << 32;
    }

    public static Instruction @NotNull [] createEmptyCfgInstructions() {
        ControlFlowBuilder builder = new ControlFlowBuilder();
        builder.startNode(null);
        builder.checkPending(builder.startNode(null));
        Instruction[] instructionArray = builder.completeControlFlow().getInstructions();
        if (instructionArray == null) {
            RControlFlowUtil.$$$reportNull$$$0(9);
        }
        return instructionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/RControlFlowUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/RControlFlowUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPredecessorsWithoutCompoundAndBlockStatements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphWithoutRBlockCall";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCfgInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectPredecessorsWithoutCompoundAndBlockStatements";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGraphWithoutRBlockCall";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeNum";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9 -> new IllegalStateException(string);
        };
    }
}

