/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelServiceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyElementFactoryCore {
    private static final Logger LOG = Logger.getInstance(RubyElementFactoryCore.class);

    private RubyElementFactoryCore() {
    }

    @NotNull
    public static List<RPsiElement> getNotEmptyTopLevelElements(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(0);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(1);
        }
        return RubyElementFactoryCore.getNotEmptyTopLevelElements(context.getProject(), text, RubyPsiUtilCore.getLanguageLevel(context));
    }

    @NotNull
    public static List<RPsiElement> getNotEmptyTopLevelElements(@NotNull Project project, @NotNull String text, @NotNull LanguageLevel languageLevel) {
        RFile file;
        List elements;
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(2);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(3);
        }
        if (languageLevel == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty((Collection)(elements = (file = RubyElementFactoryCore.createRubyFile(project, text, languageLevel)) == null ? null : file.getStatements()))) {
            throw new RuntimeException("Failed to get top level elements from text: " + text);
        }
        List list = elements;
        if (list == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public static RFile createRubyFile(@NotNull Project project, @NotNull String text, @NotNull LanguageLevel languageLevel) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(6);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(7);
        }
        if (languageLevel == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(8);
        }
        return RubyElementFactoryCore.createRubyFile(project, text, languageLevel, false);
    }

    @Nullable
    public static RFile createRubyFile(@NotNull Project project, @NotNull String text, @NotNull LanguageLevel languageLevel, boolean isPhysical) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(9);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(10);
        }
        if (languageLevel == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(11);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("temp.rb", (Language)RubyLanguage.INSTANCE, (CharSequence)text);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        RubyLanguageLevelServiceBase.registerFileLanguageLevel((VirtualFile)virtualFile, languageLevel);
        return (RFile)((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).trySetupPsiForFile(virtualFile, (Language)RubyLanguage.INSTANCE, isPhysical, true);
    }

    @NotNull
    public static RPsiElement createElementFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(12);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(13);
        }
        RPsiElement rPsiElement = RubyElementFactoryCore.getNotEmptyTopLevelElements(context, text).get(0);
        if (rPsiElement == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(14);
        }
        return rPsiElement;
    }

    @Nullable
    public static RFile createRubyFile(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(15);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(16);
        }
        return RubyElementFactoryCore.createRubyFile(project, text, false);
    }

    @Nullable
    public static RFile createRubyFile(@NotNull Project project, @NotNull String text, boolean isPhysical) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(17);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(18);
        }
        return RubyElementFactoryCore.createRubyFile(project, text, LanguageLevel.latest(), isPhysical);
    }

    @NotNull
    public static PsiElement createComma(@NotNull PsiElement context) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(19);
        }
        PsiElement psiElement = RubyElementFactoryCore.createElementFromText(context, "a,").getFirstChild().getLastChild();
        if (psiElement == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull PsiElement context) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(21);
        }
        PsiElement psiElement = RubyElementFactoryCore.createElementFromText(context, "a\nb").getNextSibling();
        if (psiElement == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public static PsiComment createPsiComment(@NotNull Project project, @NotNull String commentContents) {
        RFile rFile;
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(23);
        }
        if (commentContents == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(24);
        }
        LOG.assertTrue((rFile = RubyElementFactoryCore.createRubyFile(project, commentContents)) != null);
        PsiElement statement = rFile.getFirstChild();
        LOG.assertTrue(statement instanceof RCompoundStatement, (Object)("Compound statement expected, got " + String.valueOf(statement)));
        PsiElement comment = statement.getFirstChild();
        LOG.assertTrue(comment instanceof PsiComment, (Object)("Comment element expected, got " + String.valueOf(comment)));
        PsiComment psiComment = (PsiComment)comment;
        if (psiComment == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(25);
        }
        return psiComment;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createPsiComments(@NotNull Project project, @NotNull String commentsContents) {
        RFile rFile;
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(26);
        }
        if (commentsContents == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(27);
        }
        LOG.assertTrue((rFile = RubyElementFactoryCore.createRubyFile(project, commentsContents.trim())) != null);
        PsiElement statement = rFile.getFirstChild();
        LOG.assertTrue(statement instanceof RCompoundStatement, (Object)("Compound statement expected, got " + String.valueOf(statement)));
        PsiElement firstComment = statement.getFirstChild();
        LOG.assertTrue(firstComment instanceof PsiComment, (Object)("Comment element expected, got " + String.valueOf(firstComment)));
        PsiElement lastComment = statement.getLastChild();
        LOG.assertTrue(firstComment instanceof PsiComment, (Object)("Comment element expected, got " + String.valueOf(lastComment)));
        Pair pair = Pair.create((Object)firstComment, (Object)lastComment);
        if (pair == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(28);
        }
        return pair;
    }

    @Nullable
    public static PsiElement createFNameFromText(@NotNull PsiElement context, @NotNull String name) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(29);
        }
        if (name == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(30);
        }
        return PsiTreeUtil.getChildOfType((PsiElement)RubyElementFactoryCore.createElementFromText(context, ":" + name), RPsiElement.class);
    }

    @NotNull
    public static RExpression createExpressionFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(31);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(32);
        }
        return (RExpression)RubyElementFactoryCore.createElementFromText(context, text);
    }

    @NotNull
    public static RPsiElement createElementFromText(@NotNull Project project, @NotNull String text, @NotNull LanguageLevel languageLevel) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(33);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(34);
        }
        if (languageLevel == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(35);
        }
        RPsiElement rPsiElement = RubyElementFactoryCore.getNotEmptyTopLevelElements(project, text, languageLevel).get(0);
        if (rPsiElement == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(36);
        }
        return rPsiElement;
    }

    @NotNull
    public static RSymbol createSymbol(@NotNull PsiElement context, @NotNull String newName) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(37);
        }
        if (newName == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(38);
        }
        return RubyElementFactoryCore.createSymbol(context, newName, "'", false);
    }

    @NotNull
    public static RSymbol createSymbol(@NotNull PsiElement context, @NotNull String newName, @NotNull String quoteChar, boolean forceQuoted) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(39);
        }
        if (newName == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(40);
        }
        if (quoteChar == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(41);
        }
        PsiElement newSymbol = forceQuoted ? null : RubyElementFactoryCore.tryCreateSymbol(context, newName);
        PsiElement psiElement = newSymbol = newSymbol instanceof RSymbol ? newSymbol : RubyElementFactoryCore.tryCreateSymbol(context, quoteChar + newName + quoteChar);
        assert (newSymbol instanceof RSymbol) : "New element must be symbol, got: " + String.valueOf(newSymbol) + "\nElement text: " + newSymbol.getText();
        RSymbol rSymbol = (RSymbol)newSymbol;
        if (rSymbol == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(42);
        }
        return rSymbol;
    }

    @NotNull
    private static PsiElement tryCreateSymbol(@NotNull PsiElement context, @NotNull String newName) {
        if (context == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(43);
        }
        if (newName == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(44);
        }
        PsiElement psiElement = (PsiElement)RubyElementFactoryCore.getNotEmptyTopLevelElements(context, ":" + newName).get(0);
        if (psiElement == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(45);
        }
        return psiElement;
    }

    @NotNull
    public static RExpression createExpressionFromText(@NotNull Project project, @NotNull String text, @NotNull LanguageLevel languageLevel) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(46);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(47);
        }
        if (languageLevel == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(48);
        }
        return (RExpression)RubyElementFactoryCore.createElementFromText(project, text, languageLevel);
    }

    @NotNull
    public static RCodeBlock createCodeBlockFromText(@NotNull Project project, @NotNull String text, @NotNull LanguageLevel languageLevel) {
        if (project == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(49);
        }
        if (text == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(50);
        }
        if (languageLevel == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(51);
        }
        String codeFragment = "foo " + text;
        RExpression element = RubyElementFactoryCore.createExpressionFromText(project, codeFragment, languageLevel);
        RCodeBlock rCodeBlock = ((RBlockCall)element).getBlock();
        if (rCodeBlock == null) {
            RubyElementFactoryCore.$$$reportNull$$$0(52);
        }
        return rCodeBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 14, 20, 22, 25, 28, 36, 42, 45, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 32: 
            case 34: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 15: 
            case 17: 
            case 23: 
            case 26: 
            case 33: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 35: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 5: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 36: 
            case 42: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyElementFactoryCore";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentContents";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsContents";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteChar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyElementFactoryCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyTopLevelElements";
                break;
            }
            case 14: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementFromText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiComment";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiComments";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbol";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "tryCreateSymbol";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNotEmptyTopLevelElements";
                break;
            }
            case 5: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 36: 
            case 42: 
            case 45: 
            case 52: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRubyFile";
                break;
            }
            case 12: 
            case 13: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createComma";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createPsiComment";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createPsiComments";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFNameFromText";
                break;
            }
            case 31: 
            case 32: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createSymbol";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateSymbol";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 14, 20, 22, 25, 28, 36, 42, 45, 52 -> new IllegalStateException(string);
        };
    }
}

