/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.PsiElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyFileElementType;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyParser;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RFileImpl;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE = new RubyFileElementType();

    @NotNull
    public Lexer createLexer(Project project) {
        return new RubyLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new RubyParser(LanguageLevel.latest());
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = FILE;
        if (iFileElementType == null) {
            RubyParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = RubyTokenSets.getTWHITESPACES();
        if (tokenSet == null) {
            RubyParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenBNF.tCOMMENTS;
        if (tokenSet == null) {
            RubyParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenBNF.tSTRING_LIKE_CONTENTS;
        if (tokenSet == null) {
            RubyParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            RubyParserDefinition.$$$reportNull$$$0(4);
        }
        for (PsiElementFactory factory : PsiElementFactory.EP_NAME.getExtensionList()) {
            PsiElement element = factory.createPsiElement(node);
            if (element == null) continue;
            PsiElement psiElement = element;
            if (psiElement == null) {
                RubyParserDefinition.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        throw new RuntimeException("Unable to create PSI for node of type " + String.valueOf(node.getElementType()) + " with text " + node.getText());
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            RubyParserDefinition.$$$reportNull$$$0(6);
        }
        return new RFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (RubySpaceUtil.isAnySpace((ASTNode)right) || RubySpaceUtil.isAnySpace((ASTNode)left)) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
            if (spaceRequirements == null) {
                RubyParserDefinition.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == RubyTokenTypes.tDOUBLE_QUOTED_STRING_BEG || left.getElementType() == RubyTokenTypes.tSTRING_CONTENT || left.getElementType() == RubyTokenTypes.tHEREDOC_CONTENT || right.getElementType() == RubyTokenTypes.tSTRING_CONTENT || right.getElementType() == RubyTokenTypes.tSTRING_END) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
            if (spaceRequirements == null) {
                RubyParserDefinition.$$$reportNull$$$0(8);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == RubyTokenTypes.tSTRING_DBEG || right.getElementType() == RubyTokenTypes.tSTRING_DEND) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
            if (spaceRequirements == null) {
                RubyParserDefinition.$$$reportNull$$$0(9);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == RubyTokenTypes.TLINE_COMMENT) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                RubyParserDefinition.$$$reportNull$$$0(10);
            }
            return spaceRequirements;
        }
        PsiElement element = left.getPsi();
        RPsiElement statement = RubyPsiUtilCore.getStatement(element);
        if (statement != null && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)right.getPsi(), (boolean)false)) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                RubyParserDefinition.$$$reportNull$$$0(11);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == RubyTokenTypes.tCOLON2 || right.getElementType() == RubyTokenTypes.tCOLON2) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
            if (spaceRequirements == null) {
                RubyParserDefinition.$$$reportNull$$$0(12);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            RubyParserDefinition.$$$reportNull$$$0(13);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/parser/RubyParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/parser/RubyParserDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

