/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;

public final class TextUtil
extends RubyTextUtil {
    public static final String CONST_REGEXP = "[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*";
    private static final String METHOD_REGEXP = "[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]+[!?]?";
    private static final Pattern DOT_FQ_REF_PATTERN = Pattern.compile("[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*(::[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)*\\.[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]+[!?]?");
    private static final Pattern CID_OR_COLON_FQ_REF_PATTERN = Pattern.compile("([A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)?(::[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)*");
    private static final Pattern FIELD_PATTERN = Pattern.compile("@@?[_A-Za-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");
    public static final Pattern CONST_PATTERN = Pattern.compile("[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");
    private static final Pattern AID_PATTERN = Pattern.compile("[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*=");
    public static final Pattern INTEGER_PATTERN = Pattern.compile("^[-+]?\\d+$");
    public static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");
    public static final Pattern IDENTIFIER_LOWERCASE_PATTERN = Pattern.compile("[_a-z][_a-z0-9]*");
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";

    private TextUtil() {
    }

    @NotNull
    @NlsSafe
    public static String decapitalize(@NotNull @Nls String text) {
        if (text == null) {
            TextUtil.$$$reportNull$$$0(0);
        }
        if (text.isEmpty()) {
            String string = text;
            if (string == null) {
                TextUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = text.substring(0, 1).toLowerCase(DynamicBundle.getLocale()) + text.substring(1);
        if (string == null) {
            TextUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\f' || c == '\r' || c == '\u000b';
    }

    public static String concat(String ... strings) {
        StringBuilder result = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            if (strings[i].isEmpty()) continue;
            result.append(SPACE_STRING);
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static boolean isField(String content) {
        return FIELD_PATTERN.matcher(content).matches();
    }

    public static boolean isAID(@Nullable String content) {
        return content != null && AID_PATTERN.matcher(content).matches();
    }

    public static boolean isConstId(String content) {
        return CONST_PATTERN.matcher(content).matches();
    }

    public static boolean isIdentifier(String content) {
        return IDENTIFIER_PATTERN.matcher(content).matches();
    }

    public static boolean isMethodName(@NotNull String name) {
        if (name == null) {
            TextUtil.$$$reportNull$$$0(3);
        }
        if (!name.isEmpty() && name.length() <= 3 && RMethod.OPERATORS.contains(name)) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || i == name.length() - 1 && c == '!' || i == name.length() - 1 && c == '?' || i == name.length() - 1 && c == '=') continue;
            return false;
        }
        return true;
    }

    public static boolean isDotFullyQualifiedRef(String content) {
        return DOT_FQ_REF_PATTERN.matcher(content).matches();
    }

    public static boolean isCIDOrColonQualifiedReference(String content) {
        return CID_OR_COLON_FQ_REF_PATTERN.matcher(content).matches();
    }

    @NotNull
    public static String wrapInParens(@NotNull String s) {
        if (s == null) {
            TextUtil.$$$reportNull$$$0(4);
        }
        String string = "(" + s + ")";
        if (string == null) {
            TextUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String removeQuoting(@NonNls @Nullable String s) {
        if (s == null || s.length() <= 1) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("%q")) {
            if (s.length() > 2) {
                return s.substring(3, s.length() - 1);
            }
            return EMPTY_STRING;
        }
        return s;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void flatten(RPsiElement element, ArrayList<? super String> items) {
        if (element instanceof RArray) {
            for (RPsiElement psiItem : ((RArray)element).getElements()) {
                TextUtil.flatten(psiItem, items);
            }
        } else if (element instanceof RWords) {
            items.addAll(((RWords)element).getWords());
        } else if (element instanceof RStringLiteral) {
            items.add(TextUtil.removeQuoting(element.getText()));
        }
    }

    public static String arrayToString(@Nullable RArray array) {
        PsiElement firstChild;
        PsiElement psiElement = firstChild = array != null && array.getChildren().length > 0 ? array.getChildren()[0] : null;
        if (!(firstChild instanceof RListOfExpressions)) {
            return EMPTY_STRING;
        }
        RListOfExpressions list = (RListOfExpressions)firstChild;
        StringBuilder builder = new StringBuilder();
        List elements = list.getElements();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            RPsiElement element = (RPsiElement)i.next();
            builder.append(TextUtil.removeQuoting(element.getText()));
            if (!i.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String chomp(String s) {
        s = StringUtil.trimEnd((String)s, (String)"\n");
        s = StringUtil.trimEnd((String)s, (String)"\r");
        return s;
    }

    @Contract(value="null -> false")
    public static boolean isAnyID(@Nullable String name) {
        return TextUtil.isCID((String)name) || TextUtil.isFID((String)name) || TextUtil.isAID(name);
    }

    public static boolean isInteger(@NotNull String versionText) {
        if (versionText == null) {
            TextUtil.$$$reportNull$$$0(6);
        }
        return INTEGER_PATTERN.matcher(versionText).matches();
    }

    @NotNull
    public static String trimTrailingSlashes(@Nullable String url) {
        if (url == null) {
            return EMPTY_STRING;
        }
        for (int i = url.length() - 1; i >= 0; --i) {
            if (url.charAt(i) == '/' || url.charAt(i) == '\\') continue;
            String string = url.substring(0, i + 1);
            if (string == null) {
                TextUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        return EMPTY_STRING;
    }

    public static int getFirstIndentSize(@NotNull CharSequence text) {
        int i;
        if (text == null) {
            TextUtil.$$$reportNull$$$0(8);
        }
        for (i = 0; i < text.length() && text.charAt(i) == '\n'; ++i) {
        }
        int result = 0;
        while (i + result < text.length() && TextUtil.isWhiteSpace(text.charAt(i + result))) {
            ++result;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/TextUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/TextUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInParens";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMethodName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapInParens";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInteger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFirstIndentSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 7 -> new IllegalStateException(string);
        };
    }
}

