/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.RSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.ClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.CollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.FullyQualifiedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.HashType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.ModuleOrClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.ModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.ProcType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.QualifiedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeKind;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.UnionType;

public final class SerializableTypeUtil {
    public static final SerializableType EMPTY = new FullyQualifiedType("");
    public static final SerializableType TRUE = new FullyQualifiedType("TrueClass");
    public static final SerializableType FALSE = new FullyQualifiedType("FalseClass");
    public static final SerializableType BOOLEAN = new UnionType(Arrays.asList(TRUE, FALSE));
    public static final SerializableType NIL = new FullyQualifiedType("NilClass");
    public static final SerializableType STRING = new FullyQualifiedType("String");

    private SerializableTypeUtil() {
    }

    @NotNull
    public static SerializableType createGenericType(@NotNull SerializableType mainType, @NotNull SerializableType elementType) {
        if (mainType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(1);
        }
        return SerializableTypeUtil.createGenericType(mainType, elementType != EMPTY ? Collections.singletonList(elementType) : Collections.emptyList());
    }

    @NotNull
    public static SerializableType createGenericType(@NotNull SerializableType mainType, @NotNull List<SerializableType> elementTypes) {
        String presentableName;
        if (mainType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(2);
        }
        if (elementTypes == null) {
            SerializableTypeUtil.$$$reportNull$$$0(3);
        }
        if ((presentableName = mainType.getPresentableName()).equals("Class")) {
            return new ClassType(SerializableTypeUtil.createUnionType(elementTypes));
        }
        if (presentableName.equals("Module")) {
            return new ModuleType(SerializableTypeUtil.createUnionType(elementTypes));
        }
        return SerializableTypeUtil.createCollectionType(mainType, elementTypes);
    }

    @NotNull
    public static SerializableType createCollectionType(@NotNull SerializableType collectionType, @NotNull SerializableType elementType) {
        if (collectionType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(4);
        }
        if (elementType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(5);
        }
        return elementType == EMPTY ? collectionType : new CollectionType(collectionType, Collections.singletonList(elementType));
    }

    @NotNull
    public static SerializableType createCollectionType(@NotNull SerializableType collectionType, @NotNull List<SerializableType> elementTypes) {
        if (collectionType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(6);
        }
        if (elementTypes == null) {
            SerializableTypeUtil.$$$reportNull$$$0(7);
        }
        if (elementTypes.isEmpty()) {
            SerializableType serializableType = collectionType;
            if (serializableType == null) {
                SerializableTypeUtil.$$$reportNull$$$0(8);
            }
            return serializableType;
        }
        return new CollectionType(collectionType, elementTypes);
    }

    public static boolean isEmpty(@Nullable SerializableType serializableType) {
        return serializableType == null || serializableType == EMPTY;
    }

    @NotNull
    public static SerializableType deserialize(@NotNull StubInputStream stubInputStream) throws IOException {
        if (stubInputStream == null) {
            SerializableTypeUtil.$$$reportNull$$$0(9);
        }
        SerializableTypeKind serializableTypeKind = SerializableTypeKind.valueOf((int)stubInputStream.readVarInt());
        return switch (serializableTypeKind) {
            default -> throw new MatchException(null, null);
            case SerializableTypeKind.FULLY_QUALIFIED -> {
                String type;
                switch (type = Objects.requireNonNull(stubInputStream.readNameString())) {
                    case "": {
                        yield EMPTY;
                    }
                    case "TrueClass": {
                        yield TRUE;
                    }
                    case "FalseClass": {
                        yield FALSE;
                    }
                    case "NilClass": {
                        yield NIL;
                    }
                    case "String": {
                        yield STRING;
                    }
                }
                yield SerializableTypeUtil.createFullyQualifiedType(type);
            }
            case SerializableTypeKind.QUALIFIED -> SerializableTypeUtil.createQualifiedType(Objects.requireNonNull(stubInputStream.readNameString()));
            case SerializableTypeKind.UNION -> {
                int size = stubInputStream.readVarInt();
                ArrayList<SerializableType> types = new ArrayList<SerializableType>();
                for (int i = 0; i < size; ++i) {
                    types.add(SerializableTypeUtil.deserialize(stubInputStream));
                }
                yield SerializableTypeUtil.createUnionType(types);
            }
            case SerializableTypeKind.COLLECTION -> {
                SerializableType collectionType = SerializableTypeUtil.deserialize(stubInputStream);
                int size = stubInputStream.readVarInt();
                ArrayList<SerializableType> elementTypes = new ArrayList<SerializableType>();
                for (int i = 0; i < size; ++i) {
                    elementTypes.add(SerializableTypeUtil.deserialize(stubInputStream));
                }
                yield new CollectionType(collectionType, elementTypes);
            }
            case SerializableTypeKind.HASH -> SerializableTypeUtil.createHashType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream));
            case SerializableTypeKind.PROC -> SerializableTypeUtil.createProcType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserializeSignature(stubInputStream));
            case SerializableTypeKind.MODULE_OR_CLASS -> new ModuleOrClassType(SerializableTypeUtil.deserialize(stubInputStream));
            case SerializableTypeKind.MODULE -> new ModuleType(SerializableTypeUtil.deserialize(stubInputStream));
            case SerializableTypeKind.CLASS -> new ClassType(SerializableTypeUtil.deserialize(stubInputStream));
        };
    }

    public static void serialize(@NotNull StubOutputStream stream, @NotNull SerializableType type) throws IOException {
        if (stream == null) {
            SerializableTypeUtil.$$$reportNull$$$0(10);
        }
        if (type == null) {
            SerializableTypeUtil.$$$reportNull$$$0(11);
        }
        stream.writeVarInt(type.getKind().getOrder());
        switch (type.getKind()) {
            case FULLY_QUALIFIED: {
                stream.writeName(((FullyQualifiedType)type).getType());
                break;
            }
            case QUALIFIED: {
                stream.writeName(((QualifiedType)type).getType());
                break;
            }
            case UNION: {
                UnionType unionType = (UnionType)type;
                stream.writeVarInt(unionType.getTypes().size());
                for (SerializableType serializableType : unionType.getTypes()) {
                    SerializableTypeUtil.serialize(stream, serializableType);
                }
                break;
            }
            case COLLECTION: {
                CollectionType collectionType = (CollectionType)type;
                SerializableTypeUtil.serialize(stream, collectionType.getBaseType());
                List<SerializableType> elementTypes = collectionType.getElementTypes();
                stream.writeVarInt(elementTypes.size());
                for (SerializableType elementType : elementTypes) {
                    SerializableTypeUtil.serialize(stream, elementType);
                }
                break;
            }
            case HASH: {
                HashType hashType = (HashType)type;
                SerializableTypeUtil.serialize(stream, hashType.getHashType());
                SerializableTypeUtil.serialize(stream, hashType.getKeyType());
                SerializableTypeUtil.serialize(stream, hashType.getValueType());
                break;
            }
            case PROC: {
                ProcType procType = (ProcType)type;
                SerializableTypeUtil.serialize(stream, procType.getSelfType());
                SerializableTypeUtil.serializeSignature(stream, procType.getSignature());
                break;
            }
            case MODULE_OR_CLASS: {
                ModuleOrClassType moduleOrClassType = (ModuleOrClassType)type;
                SerializableTypeUtil.serialize(stream, moduleOrClassType.getOriginalType());
                break;
            }
            case MODULE: {
                ModuleType moduleType = (ModuleType)type;
                SerializableTypeUtil.serialize(stream, moduleType.getOriginalType());
                break;
            }
            case CLASS: {
                ClassType classType = (ClassType)type;
                SerializableTypeUtil.serialize(stream, classType.getOriginalType());
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to serialize " + String.valueOf(type.getKind()));
            }
        }
    }

    public static void serializeSignature(@NotNull StubOutputStream dataStream, @NotNull RSignature signature) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.$$$reportNull$$$0(12);
        }
        if (signature == null) {
            SerializableTypeUtil.$$$reportNull$$$0(13);
        }
        DataInputOutputUtilRt.writeSeq((DataOutput)dataStream, (Collection)signature.getParameterTypes(), argument -> SerializableTypeUtil.serializeTypedArgument(dataStream, argument));
        SerializableTypeUtil.serialize(dataStream, signature.getReturnType());
    }

    @NotNull
    public static RSignature deserializeSignature(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.$$$reportNull$$$0(14);
        }
        List params = DataInputOutputUtilRt.readSeq((DataInput)dataStream, () -> SerializableTypeUtil.deserializeTypedArgument(dataStream));
        SerializableType returnType = SerializableTypeUtil.deserialize(dataStream);
        return new RSignature(params, returnType);
    }

    public static void serializeTypedArgument(@NotNull StubOutputStream dataStream, @NotNull RSignature.TypedArgument argument) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.$$$reportNull$$$0(15);
        }
        if (argument == null) {
            SerializableTypeUtil.$$$reportNull$$$0(16);
        }
        dataStream.writeName(argument.name);
        SerializableTypeUtil.serialize(dataStream, argument.type);
    }

    public static boolean isProbableNil(@NotNull SerializableType type) {
        if (type == null) {
            SerializableTypeUtil.$$$reportNull$$$0(17);
        }
        if (type instanceof UnionType) {
            return ContainerUtil.exists(((UnionType)type).getTypes(), it -> SerializableTypeUtil.isProbableNil(it));
        }
        if (type instanceof QualifiedType) {
            return ((QualifiedType)type).getType().equals("NilClass");
        }
        if (type instanceof FullyQualifiedType) {
            return ((FullyQualifiedType)type).getType().equals("NilClass");
        }
        return false;
    }

    @NotNull
    public static RSignature.TypedArgument deserializeTypedArgument(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.$$$reportNull$$$0(18);
        }
        return new RSignature.TypedArgument(Objects.requireNonNull(dataStream.readNameString()), SerializableTypeUtil.deserialize(dataStream));
    }

    @NotNull
    public static SerializableType createFullyQualifiedType(@NotNull String fqn) {
        if (fqn == null) {
            SerializableTypeUtil.$$$reportNull$$$0(19);
        }
        return new FullyQualifiedType(fqn);
    }

    @NotNull
    public static SerializableType createQualifiedType(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            SerializableTypeUtil.$$$reportNull$$$0(20);
        }
        return new QualifiedType(qualifiedName);
    }

    @NotNull
    public static SerializableType createUnionType(@NotNull Collection<SerializableType> serializableTypes) {
        List filteredSerializableTypes;
        if (serializableTypes == null) {
            SerializableTypeUtil.$$$reportNull$$$0(21);
        }
        if ((filteredSerializableTypes = ContainerUtil.filter(serializableTypes, type -> type != EMPTY)).isEmpty()) {
            SerializableType serializableType = EMPTY;
            if (serializableType == null) {
                SerializableTypeUtil.$$$reportNull$$$0(22);
            }
            return serializableType;
        }
        if (filteredSerializableTypes.size() == 1) {
            SerializableType serializableType = (SerializableType)filteredSerializableTypes.get(0);
            if (serializableType == null) {
                SerializableTypeUtil.$$$reportNull$$$0(23);
            }
            return serializableType;
        }
        return new UnionType(filteredSerializableTypes);
    }

    @NotNull
    public static SerializableType createHashType(@NotNull SerializableType hashType, @NotNull SerializableType keyType, @NotNull SerializableType valueType) {
        if (hashType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(24);
        }
        if (keyType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(25);
        }
        if (valueType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(26);
        }
        if (keyType == EMPTY && valueType == EMPTY) {
            SerializableType serializableType = hashType;
            if (serializableType == null) {
                SerializableTypeUtil.$$$reportNull$$$0(27);
            }
            return serializableType;
        }
        return new HashType(hashType, keyType, valueType);
    }

    public static SerializableType createProcType(@NotNull SerializableType selfType, @NotNull RSignature signature) {
        if (selfType == null) {
            SerializableTypeUtil.$$$reportNull$$$0(28);
        }
        if (signature == null) {
            SerializableTypeUtil.$$$reportNull$$$0(29);
        }
        return new ProcType(selfType, signature);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 22, 23, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionType";
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/serializable/SerializableTypeUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubInputStream";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/serializable/SerializableTypeUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollectionType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnionType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGenericType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionType";
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 27: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serializeSignature";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeSignature";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "serializeTypedArgument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isProbableNil";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTypedArgument";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFullyQualifiedType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUnionType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createHashType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createProcType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 22, 23, 27 -> new IllegalStateException(string);
        };
    }
}

