/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RIntersectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RUnionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RTypeBase;

public final class RUnionTypeImpl
extends RTypeBase
implements RUnionType {
    private final List<RType> myTypes;

    private RUnionTypeImpl(@NotNull List<RType> types) {
        if (types == null) {
            RUnionTypeImpl.$$$reportNull$$$0(0);
        }
        this.myTypes = List.copyOf(types);
    }

    @NotNull
    public Collection<? extends Symbol> getMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (filter == null) {
            RUnionTypeImpl.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        Collection collection = this.myTypes.stream().map(type -> type.getMembers(filter, invocationPoint)).reduce(Collections.emptySet(), RTypeUtilCore::intersection);
        if (collection == null) {
            RUnionTypeImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            RUnionTypeImpl.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            RUnionTypeImpl.$$$reportNull$$$0(4);
        }
        this.getMembers(filter, invocationPoint).forEach(consumer);
    }

    @Nullable
    public Symbol getMemberForName(@NotNull String name, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (name == null) {
            RUnionTypeImpl.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            RUnionTypeImpl.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        return this.myTypes.stream().map(type -> type.getMemberForName(name, filter, invocationPoint)).filter(Objects::nonNull).distinct().reduce((xva$0, xva$1) -> MultiSymbol.of(xva$0, xva$1)).orElse(null);
    }

    public boolean isTyped() {
        return ContainerUtil.or(this.myTypes, RType::isTyped);
    }

    @NotNull
    public String toString() {
        String string = StringUtil.join(this.myTypes, (String)" & ");
        if (string == null) {
            RUnionTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.getName(false);
    }

    @Nullable
    public String getName(boolean parenthesizeIfNecessary) {
        List names = ContainerUtil.mapNotNull(this.myTypes, type -> {
            String string;
            if (type instanceof RIntersectionType) {
                RIntersectionType intersectionType = (RIntersectionType)type;
                string = intersectionType.getName(true);
            } else {
                string = type.getName();
            }
            return string;
        });
        if (names.isEmpty()) {
            return null;
        }
        String name = String.join((CharSequence)" | ", names);
        return names.size() > 1 && parenthesizeIfNecessary ? String.format("(%s)", name) : name;
    }

    @Nullable
    public String getPresentableName() {
        return this.getPresentableName(false);
    }

    @Nullable
    public String getPresentableName(boolean parenthesizeIfNecessary) {
        List names = ContainerUtil.mapNotNull(this.myTypes, type -> {
            String string;
            if (type instanceof RIntersectionType) {
                RIntersectionType intersectionType = (RIntersectionType)type;
                string = intersectionType.getPresentableName(true);
            } else {
                string = type.getPresentableName();
            }
            return string;
        });
        if (names.isEmpty()) {
            return null;
        }
        String name = String.join((CharSequence)" | ", names);
        return names.size() > 1 && parenthesizeIfNecessary ? String.format("(%s)", name) : name;
    }

    @NotNull
    public RubyCompletionGrouping getGroupForMember(@NotNull Symbol member) {
        if (member == null) {
            RUnionTypeImpl.$$$reportNull$$$0(8);
        }
        RubyCompletionGrouping rubyCompletionGrouping = this.myTypes.stream().map(type -> type.getGroupForMember(member)).filter(group -> group != RubyCompletionGrouping.GENERAL).max(Comparator.comparing(RubyCompletionGrouping::getValue)).orElse(RubyCompletionGrouping.GENERAL);
        if (rubyCompletionGrouping == null) {
            RUnionTypeImpl.$$$reportNull$$$0(9);
        }
        return rubyCompletionGrouping;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Comparing.haveEqualElements(this.myTypes, ((RUnionTypeImpl)obj).myTypes);
    }

    public int hashCode() {
        return this.myTypes.hashCode();
    }

    @NotNull
    public List<RType> getTypes() {
        List<RType> list = this.myTypes;
        if (list == null) {
            RUnionTypeImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public static RType create(@NotNull List<RType> types) {
        if (types == null) {
            RUnionTypeImpl.$$$reportNull$$$0(11);
        }
        return new RUnionTypeImpl(types);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RUnionTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RUnionTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupForMember";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMemberForName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGroupForMember";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

