/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RDuckType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RTypeBase;

public final class RDuckTypeImpl
extends RTypeBase
implements RDuckType {
    private final Set<Symbol> myAllMembers;
    private final Map<String, Symbol> myMembers;
    private final boolean myIsTyped;

    public RDuckTypeImpl() {
        this(Collections.emptyList(), false);
    }

    public RDuckTypeImpl(@NotNull Collection<? extends Symbol> symbols) {
        if (symbols == null) {
            RDuckTypeImpl.$$$reportNull$$$0(0);
        }
        this(symbols, false);
    }

    public RDuckTypeImpl(@NotNull Collection<? extends Symbol> symbols, boolean isTyped) {
        if (symbols == null) {
            RDuckTypeImpl.$$$reportNull$$$0(1);
        }
        this.myAllMembers = new CopyOnWriteArraySet<Symbol>();
        this.myMembers = new ConcurrentHashMap<String, Symbol>();
        for (Symbol symbol : symbols) {
            this.addMember(symbol);
        }
        this.myIsTyped = isTyped;
    }

    public void clear() {
        this.myAllMembers.clear();
        this.myMembers.clear();
    }

    @NotNull
    public RType addMember(@NotNull Symbol member) {
        if (member == null) {
            RDuckTypeImpl.$$$reportNull$$$0(2);
        }
        this.myAllMembers.add(member);
        String name = member.getName();
        if (name != null) {
            this.myMembers.put(name, member);
        }
        RDuckTypeImpl rDuckTypeImpl = this;
        if (rDuckTypeImpl == null) {
            RDuckTypeImpl.$$$reportNull$$$0(3);
        }
        return rDuckTypeImpl;
    }

    public boolean isTyped() {
        return this.myIsTyped;
    }

    @NotNull
    public Collection<Symbol> getMembers(@NotNull Predicate<? super Symbol> filter, PsiElement invocationPoint) {
        if (filter == null) {
            RDuckTypeImpl.$$$reportNull$$$0(4);
        }
        Set<Symbol> set = this.myAllMembers;
        if (set == null) {
            RDuckTypeImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            RDuckTypeImpl.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            RDuckTypeImpl.$$$reportNull$$$0(7);
        }
        this.myAllMembers.forEach(consumer);
    }

    @Nullable
    public Symbol getMemberForName(@NotNull String name, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        Symbol symbol;
        if (name == null) {
            RDuckTypeImpl.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            RDuckTypeImpl.$$$reportNull$$$0(9);
        }
        return (symbol = this.myMembers.get(name)) != null && filter.test((Symbol)symbol) && (invocationPoint == null || symbol.getPsiElement() != invocationPoint) && symbol.isResolvable() ? symbol : null;
    }

    @NonNls
    public String toString() {
        return "Duck type (" + this.myAllMembers.size() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RDuckTypeImpl that = (RDuckTypeImpl)o;
        return Comparing.haveEqualElements(this.myAllMembers, that.myAllMembers);
    }

    public String getName() {
        if (ApplicationManager.getApplication().isInternal() && !this.myMembers.isEmpty()) {
            return String.format("[%s]", String.join((CharSequence)", ", ContainerUtil.sorted(this.myMembers.keySet())));
        }
        return null;
    }

    public String getPresentableName() {
        return this.getName();
    }

    public int hashCode() {
        return this.myAllMembers.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RDuckTypeImpl";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RDuckTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addMember";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMember";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMemberForName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

