/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDReturnTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDTypeTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;

public final class RubyCommentsHelper {
    private RubyCommentsHelper() {
    }

    @Contract(value="null,_,_->null;_,null,_->null")
    @Nullable
    public static SerializableType extractYARDVariableTypeAnnotationFromComment(@Nullable String helpWithoutLeadingSharps, @Nullable String varName, boolean allowAnnotationWithoutVarName) {
        if (helpWithoutLeadingSharps == null || varName == null) {
            return null;
        }
        for (YARDTag yardTag : YARDParser.parse(helpWithoutLeadingSharps)) {
            String nameInAnnotation;
            if (!(yardTag instanceof YARDTypeTag) || !varName.equals(nameInAnnotation = ((YARDTypeTag)yardTag).getName()) && (!allowAnnotationWithoutVarName || !StringUtil.isEmpty((String)nameInAnnotation))) continue;
            return ((YARDTypeTag)yardTag).getType();
        }
        return null;
    }

    @NotNull
    public static SerializableType extractYARDReturnTypeAnnotationFromComment(@NotNull String helpWithoutLeadingSharps) {
        if (helpWithoutLeadingSharps == null) {
            RubyCommentsHelper.$$$reportNull$$$0(0);
        }
        return RubyCommentsHelper.getYARDReturnType(YARDParser.parse(helpWithoutLeadingSharps));
    }

    @NotNull
    public static SerializableType getYARDReturnType(@NotNull List<YARDTag> tags) {
        if (tags == null) {
            RubyCommentsHelper.$$$reportNull$$$0(1);
        }
        SerializableType serializableType = SerializableTypeUtil.createUnionType(tags.stream().filter(it -> it instanceof YARDReturnTag).map(it -> ((YARDReturnTag)it).getType()).collect(Collectors.toList()));
        if (serializableType == null) {
            RubyCommentsHelper.$$$reportNull$$$0(2);
        }
        return serializableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpWithoutLeadingSharps";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RubyCommentsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RubyCommentsHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getYARDReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractYARDReturnTypeAnnotationFromComment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getYARDReturnType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

