/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;

public final class MultiSymbol
extends SymbolImpl {
    private final List<Symbol> mySymbols;

    private MultiSymbol(Symbol ... symbols) {
        super(symbols[0].getProject(), symbols[0].getName(), symbols[0].getType(), null);
        this.mySymbols = List.of(symbols);
    }

    @NotNull
    public List<Symbol> getSymbols() {
        List<Symbol> list = this.mySymbols;
        if (list == null) {
            MultiSymbol.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public PsiElement getPsiElement() {
        return ((Symbol)ContainerUtil.getLastItem(this.mySymbols)).getPsiElement();
    }

    @NotNull
    public Collection<PsiElement> getAllDeclarations(@Nullable PsiElement invocationPoint) {
        ArrayList<PsiElement> declarations = new ArrayList<PsiElement>();
        for (Symbol symbol : this.mySymbols) {
            declarations.addAll(symbol.getAllDeclarations(invocationPoint));
        }
        ArrayList<PsiElement> arrayList = declarations;
        if (arrayList == null) {
            MultiSymbol.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public Symbol getSingletonClassSymbol() {
        List symbols = ContainerUtil.mapNotNull(this.mySymbols, Symbol::getSingletonClassSymbol);
        if (symbols.isEmpty()) {
            return null;
        }
        return new MultiSymbol(symbols.toArray(new Symbol[0]));
    }

    @Override
    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        for (Symbol symbol : this.mySymbols) {
            if (symbol.processChildren(processor, invocationPoint)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiSymbol that = (MultiSymbol)o;
        return this.mySymbols.equals(that.mySymbols);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.mySymbols.hashCode();
    }

    @NotNull
    public static Symbol of(@NotNull List<Symbol> symbols) {
        if (symbols == null) {
            MultiSymbol.$$$reportNull$$$0(2);
        }
        if (symbols.size() == 1) {
            Symbol symbol = symbols.get(0);
            if (symbol == null) {
                MultiSymbol.$$$reportNull$$$0(3);
            }
            return symbol;
        }
        return new MultiSymbol(ContainerUtil.flatMap(symbols, it -> {
            List<Object> list;
            if (it instanceof MultiSymbol) {
                MultiSymbol multiSymbol = (MultiSymbol)it;
                list = List.of(multiSymbol.getSymbols());
            } else {
                list = List.of(it);
            }
            return list;
        }).toArray(new Symbol[0]));
    }

    @NotNull
    public static Symbol of(Symbol ... symbols) {
        if (symbols == null) {
            MultiSymbol.$$$reportNull$$$0(4);
        }
        assert (symbols.length != 0);
        if (symbols.length == 1) {
            Symbol symbol = symbols[0];
            if (symbol == null) {
                MultiSymbol.$$$reportNull$$$0(5);
            }
            return symbol;
        }
        return new MultiSymbol(symbols);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/MultiSymbol";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbols";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeclarations";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/MultiSymbol";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

