/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.IncomingType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionSerializationHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionVisitor;

public class SymbolicCallImpl
extends SymbolicExpressionBase
implements SymbolicCall {
    @NotNull
    private final List<SymbolicCall.SymbolicArgumentInfo> myArguments;
    @NotNull
    private final String myName;
    @Nullable
    private final SymbolicExpression myReceiver;
    private final boolean myIsConstant;
    private final int myRetainedSize;
    private final boolean myIsBlockGiven;

    public SymbolicCallImpl(@NotNull SymbolicExpression.IdSupplier id, @NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments, @NotNull String fqn, @Nullable SymbolicExpression receiver, boolean isConstant, boolean isBlockGiven) {
        if (id == null) {
            SymbolicCallImpl.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            SymbolicCallImpl.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            SymbolicCallImpl.$$$reportNull$$$0(2);
        }
        super(id);
        this.myArguments = arguments;
        this.myName = fqn;
        this.myReceiver = receiver;
        this.myIsConstant = isConstant;
        this.myIsBlockGiven = isBlockGiven;
        this.myRetainedSize = (receiver != null ? receiver.getRetainedSize() : 0) + arguments.stream().mapToInt(it -> it.getExpression().getRetainedSize()).sum() + 1;
    }

    @NotNull
    public List<SymbolicCall.SymbolicArgumentInfo> getArguments() {
        List<SymbolicCall.SymbolicArgumentInfo> list = this.myArguments;
        if (list == null) {
            SymbolicCallImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SymbolicCallImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public SymbolicExpression getReceiver() {
        return this.myReceiver;
    }

    public boolean isConstant() {
        return this.myIsConstant;
    }

    public boolean isBlockGiven() {
        return this.myIsBlockGiven;
    }

    @NotNull
    public SymbolicExpressionSerializationHelper<SymbolicCallImpl> getSerializationHelper() {
        SymbolicCallSerializationHelper symbolicCallSerializationHelper = SymbolicCallSerializationHelper.INSTANCE;
        if (symbolicCallSerializationHelper == null) {
            SymbolicCallImpl.$$$reportNull$$$0(5);
        }
        return symbolicCallSerializationHelper;
    }

    @NotNull
    public SymbolicExpression trySimplify(@NotNull SymbolicExpressionProvider provider) {
        if (provider == null) {
            SymbolicCallImpl.$$$reportNull$$$0(6);
        }
        if (this.myReceiver == null) {
            SymbolicCallImpl symbolicCallImpl = this;
            if (symbolicCallImpl == null) {
                SymbolicCallImpl.$$$reportNull$$$0(7);
            }
            return symbolicCallImpl;
        }
        SymbolicExpression simplifiedReceiver = this.myReceiver.trySimplify(provider);
        List simplifiedArgs = ContainerUtil.map(this.myArguments, it -> it.trySimplify(provider));
        SymbolicExpression symbolicExpression = (SymbolicExpression)ObjectUtils.chooseNotNull((Object)simplifiedReceiver.callMethod(this.myName, simplifiedArgs, provider), (Object)this);
        if (symbolicExpression == null) {
            SymbolicCallImpl.$$$reportNull$$$0(8);
        }
        return symbolicExpression;
    }

    public <T> T accept(@NotNull SymbolicExpressionVisitor<T> visitor) {
        if (visitor == null) {
            SymbolicCallImpl.$$$reportNull$$$0(9);
        }
        return (T)visitor.visitSymbolicCall((SymbolicCall)this);
    }

    @NotNull
    public List<? extends SymbolicExpression> getChildren() {
        List expressions = this.myArguments.stream().map(SymbolicCall.SymbolicArgumentInfo::getExpression).collect(Collectors.toCollection(ArrayList::new));
        if (this.myReceiver != null) {
            expressions.add(this.myReceiver);
        }
        List list = expressions;
        if (list == null) {
            SymbolicCallImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    public int getRetainedSize() {
        return this.myRetainedSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicCallImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicCallImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationHelper";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "trySimplify";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trySimplify";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static final class SymbolicCallSerializationHelper
    extends Enum<SymbolicCallSerializationHelper>
    implements SymbolicExpressionSerializationHelper<SymbolicCallImpl> {
        public static final /* enum */ SymbolicCallSerializationHelper INSTANCE = new SymbolicCallSerializationHelper();
        private static final /* synthetic */ SymbolicCallSerializationHelper[] $VALUES;

        public static SymbolicCallSerializationHelper[] values() {
            return (SymbolicCallSerializationHelper[])$VALUES.clone();
        }

        public static SymbolicCallSerializationHelper valueOf(String name) {
            return Enum.valueOf(SymbolicCallSerializationHelper.class, name);
        }

        public void serialize(@NotNull SymbolicCallImpl symbolicExpression, @NotNull StubOutputStream outputStream) throws IOException {
            if (symbolicExpression == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(0);
            }
            if (outputStream == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(1);
            }
            outputStream.writeVarInt(symbolicExpression.getId());
            outputStream.writeName(symbolicExpression.getName());
            outputStream.writeVarInt(symbolicExpression.getReceiver() != null ? symbolicExpression.getReceiver().getId() : 0);
            outputStream.writeVarInt(symbolicExpression.getArguments().size());
            for (SymbolicCall.SymbolicArgumentInfo it : symbolicExpression.getArguments()) {
                SymbolicCallSerializationHelper.serializeSymbolicArgumentInfo(it, outputStream);
            }
            outputStream.writeBoolean(symbolicExpression.isConstant());
            outputStream.writeBoolean(symbolicExpression.myIsBlockGiven);
            symbolicExpression.serializeAttributes(outputStream);
        }

        public SymbolicCallImpl deserialize(@NotNull StubInputStream inputStream, @NotNull Map<Integer, SymbolicExpression> id2SymbolicExpression) throws IOException {
            if (inputStream == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(2);
            }
            if (id2SymbolicExpression == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(3);
            }
            int id = inputStream.readVarInt();
            String name = inputStream.readNameString();
            assert (name != null);
            int receiverId = inputStream.readVarInt();
            SymbolicExpression receiver = id2SymbolicExpression.get(receiverId);
            int size = inputStream.readVarInt();
            ArrayList<SymbolicCall.SymbolicArgumentInfo> expressions = new ArrayList<SymbolicCall.SymbolicArgumentInfo>();
            for (int i = 0; i < size; ++i) {
                expressions.add(SymbolicCallSerializationHelper.deserializeSymbolicArgumentInfo(inputStream, id2SymbolicExpression));
            }
            boolean isConstant = inputStream.readBoolean();
            boolean isBlockGiven = inputStream.readBoolean();
            SymbolicCallImpl call = new SymbolicCallImpl(() -> id, expressions, name, receiver, isConstant, isBlockGiven);
            call.deserializeAttributes(inputStream);
            return call;
        }

        private static void serializeSymbolicArgumentInfo(@NotNull SymbolicCall.SymbolicArgumentInfo symbolicArgumentInfo, @NotNull StubOutputStream outputStream) throws IOException {
            if (symbolicArgumentInfo == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(4);
            }
            if (outputStream == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(5);
            }
            outputStream.writeVarInt(symbolicArgumentInfo.getExpression().getId());
            outputStream.writeName(symbolicArgumentInfo.getKeyName());
            outputStream.writeName(symbolicArgumentInfo.getType().name());
        }

        private static SymbolicCall.SymbolicArgumentInfo deserializeSymbolicArgumentInfo(@NotNull StubInputStream inputStream, @NotNull Map<Integer, SymbolicExpression> id2SymbolicExpression) throws IOException {
            if (inputStream == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(6);
            }
            if (id2SymbolicExpression == null) {
                SymbolicCallSerializationHelper.$$$reportNull$$$0(7);
            }
            int argumentId = inputStream.readVarInt();
            SymbolicExpression symbolicExpression = id2SymbolicExpression.get(argumentId);
            String keyName = Objects.requireNonNull(inputStream.readNameString());
            IncomingType incomingType = IncomingType.valueOf((String)inputStream.readNameString());
            return new SymbolicCall.SymbolicArgumentInfo(incomingType, keyName, symbolicExpression);
        }

        private static /* synthetic */ SymbolicCallSerializationHelper[] $values() {
            return new SymbolicCallSerializationHelper[]{INSTANCE};
        }

        static {
            $VALUES = SymbolicCallSerializationHelper.$values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolicExpression";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputStream";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputStream";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id2SymbolicExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolicArgumentInfo";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicCallImpl$SymbolicCallSerializationHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serialize";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserialize";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serializeSymbolicArgumentInfo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserializeSymbolicArgumentInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

