/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BinarySymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionSerializationHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionVisitor;

public class BinarySymbolicExpressionImpl
extends SymbolicExpressionBase
implements BinarySymbolicExpression {
    @NotNull
    private final SymbolicExpression myLeftOperand;
    @NotNull
    private final SymbolicExpression myRightOperand;
    @NotNull
    private final BinarySymbolicExpression.OperationKind myOperationKind;
    private final int myRetainedSize;

    public BinarySymbolicExpressionImpl(@NotNull SymbolicExpression.IdSupplier id, @NotNull SymbolicExpression leftOperand, @NotNull SymbolicExpression rightOperand, @NotNull BinarySymbolicExpression.OperationKind kind) {
        if (id == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(0);
        }
        if (leftOperand == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(1);
        }
        if (rightOperand == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(3);
        }
        super(id);
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
        this.myOperationKind = kind;
        this.myRetainedSize = leftOperand.getRetainedSize() + rightOperand.getRetainedSize() + 1;
    }

    @NotNull
    public SymbolicExpression getLeftOperand() {
        SymbolicExpression symbolicExpression = this.myLeftOperand;
        if (symbolicExpression == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(4);
        }
        return symbolicExpression;
    }

    @NotNull
    public SymbolicExpression getRightOperand() {
        SymbolicExpression symbolicExpression = this.myRightOperand;
        if (symbolicExpression == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(5);
        }
        return symbolicExpression;
    }

    @NotNull
    public BinarySymbolicExpression.OperationKind getOperationKind() {
        BinarySymbolicExpression.OperationKind operationKind = this.myOperationKind;
        if (operationKind == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(6);
        }
        return operationKind;
    }

    @NotNull
    public SymbolicExpressionSerializationHelper<BinarySymbolicExpressionImpl> getSerializationHelper() {
        BinarySymbolicExpressionSerializationHelper binarySymbolicExpressionSerializationHelper = BinarySymbolicExpressionSerializationHelper.INSTANCE;
        if (binarySymbolicExpressionSerializationHelper == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(7);
        }
        return binarySymbolicExpressionSerializationHelper;
    }

    public <T> T accept(@NotNull SymbolicExpressionVisitor<T> visitor) {
        if (visitor == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(8);
        }
        return (T)visitor.visitBinarySymbolicExpression((BinarySymbolicExpression)this);
    }

    @NotNull
    public SymbolicExpression trySimplify(@NotNull SymbolicExpressionProvider provider) {
        if (provider == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(9);
        }
        SymbolicExpression leftSimplified = this.myLeftOperand.trySimplify(provider);
        SymbolicExpression rightSimplified = this.myRightOperand.trySimplify(provider);
        SymbolicExpression binOperationApplied = leftSimplified.applyBinaryOperation(this.getOperationKind(), rightSimplified, provider);
        SymbolicExpression symbolicExpression = (SymbolicExpression)ObjectUtils.chooseNotNull((Object)binOperationApplied, (Object)this);
        if (symbolicExpression == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(10);
        }
        return symbolicExpression;
    }

    @NotNull
    public List<? extends SymbolicExpression> getChildren() {
        List<SymbolicExpression> list = Arrays.asList(this.myLeftOperand, this.myRightOperand);
        if (list == null) {
            BinarySymbolicExpressionImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    public int getRetainedSize() {
        return this.myRetainedSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/BinarySymbolicExpressionImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/BinarySymbolicExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftOperand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightOperand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "trySimplify";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "trySimplify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static enum BinarySymbolicExpressionSerializationHelper implements SymbolicExpressionSerializationHelper<BinarySymbolicExpressionImpl>
    {
        INSTANCE{

            public void serialize(@NotNull BinarySymbolicExpressionImpl symbolicExpression, @NotNull StubOutputStream outputStream) throws IOException {
                if (symbolicExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputStream == null) {
                    1.$$$reportNull$$$0(1);
                }
                outputStream.writeVarInt(symbolicExpression.getId());
                outputStream.writeVarInt(symbolicExpression.getLeftOperand().getId());
                outputStream.writeVarInt(symbolicExpression.getRightOperand().getId());
                outputStream.writeName(symbolicExpression.getOperationKind().name());
                symbolicExpression.serializeAttributes(outputStream);
            }

            public BinarySymbolicExpressionImpl deserialize(@NotNull StubInputStream inputStream, @NotNull Map<Integer, SymbolicExpression> id2SymbolicExpression) throws IOException {
                if (inputStream == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (id2SymbolicExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
                int id = inputStream.readVarInt();
                SymbolicExpression leftOperand = id2SymbolicExpression.get(inputStream.readVarInt());
                SymbolicExpression rightOperand = id2SymbolicExpression.get(inputStream.readVarInt());
                BinarySymbolicExpression.OperationKind operationKind = BinarySymbolicExpression.OperationKind.valueOf((String)inputStream.readNameString());
                BinarySymbolicExpressionImpl expression = new BinarySymbolicExpressionImpl(() -> id, leftOperand, rightOperand, operationKind);
                expression.deserializeAttributes(inputStream);
                return expression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbolicExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputStream";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputStream";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id2SymbolicExpression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/BinarySymbolicExpressionImpl$BinarySymbolicExpressionSerializationHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serialize";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deserialize";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

    }
}

