/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionEngine;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionResultImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SymbolicExecutionInstance;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtilCore;

public final class SymbolicExecutionEngineImpl
implements SymbolicExecutionEngine {
    @NotNull
    private final Graph<Instruction> myControlFlowGraph;
    @NotNull
    private final SymbolicExecutionInstance mySymbolicExecution;
    @NotNull
    private final SymbolicExecutionResult myResult;
    @NotNull
    private final Object2IntMap<Instruction> myInstruction2NNumber;
    @NotNull
    private final DFSTBuilder<Instruction> myDfsTBuilder;

    public SymbolicExecutionEngineImpl(@NotNull Graph<Instruction> controlFlowGraph, @NotNull SymbolicExecutionInstance symbolicExecution) {
        if (controlFlowGraph == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(0);
        }
        if (symbolicExecution == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(1);
        }
        this.myControlFlowGraph = controlFlowGraph;
        this.mySymbolicExecution = symbolicExecution;
        this.myResult = new SymbolicExecutionResultImpl(controlFlowGraph.getNodes().size(), this.mySymbolicExecution.getMethodContext());
        this.myInstruction2NNumber = new Object2IntOpenHashMap();
        this.myInstruction2NNumber.defaultReturnValue(-1);
        this.myDfsTBuilder = new DFSTBuilder(this.myControlFlowGraph, (Object)InstructionGraphUtilCore.getEntry(this.myControlFlowGraph));
        for (int i = 0; i < this.myControlFlowGraph.getNodes().size(); ++i) {
            this.myInstruction2NNumber.put((Object)((Instruction)this.myDfsTBuilder.getNodeByNNumber(i)), i);
        }
    }

    @NotNull
    public SymbolicExecutionResult getResult() {
        SymbolicExecutionResult symbolicExecutionResult = this.myResult;
        if (symbolicExecutionResult == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(2);
        }
        return symbolicExecutionResult;
    }

    public void performSymbolicExecution() {
        this.performSymbolicExecution(this.myResult.getInstruction2OutContext(), this.myResult.getMethodContext());
    }

    private void performSymbolicExecution(@NotNull Map<Instruction, SymbolicExecutionContext> contexts, @NotNull SymbolicExpressionProvider methodContext) {
        if (contexts == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(3);
        }
        if (methodContext == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(4);
        }
        int length = this.myControlFlowGraph.getNodes().size();
        contexts.put((Instruction)this.myDfsTBuilder.getNodeByNNumber(0), this.mySymbolicExecution.initialContext());
        for (int i = 0; i < length; ++i) {
            SymbolicExecutionContext currentContext;
            Instruction instruction = (Instruction)this.myDfsTBuilder.getNodeByNNumber(i);
            ProgressManager.checkCanceled();
            Iterator<Instruction> noBackEdgesIterator = this.getPredecessorsWithoutBackEdges(instruction);
            if (noBackEdgesIterator.hasNext()) {
                Instruction firstElement = noBackEdgesIterator.next();
                if (!noBackEdgesIterator.hasNext()) {
                    SymbolicExecutionContext context = contexts.get(firstElement);
                    currentContext = firstElement.allSucc().size() > 1 ? this.mySymbolicExecution.copy(context) : context;
                } else {
                    currentContext = contexts.get(firstElement);
                    while (noBackEdgesIterator.hasNext()) {
                        SymbolicExecutionContext predecessorContext = contexts.get(noBackEdgesIterator.next());
                        if (predecessorContext == null) continue;
                        currentContext = this.mySymbolicExecution.join(currentContext, predecessorContext, methodContext);
                    }
                }
            } else {
                currentContext = this.mySymbolicExecution.initialContext();
            }
            this.mySymbolicExecution.fun(currentContext, methodContext, instruction);
            contexts.put(instruction, currentContext);
        }
    }

    @NotNull
    private Iterator<Instruction> getPredecessorsWithoutBackEdges(@NotNull Instruction instruction) {
        if (instruction == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(5);
        }
        Iterator iterator = ContainerUtil.filterIterator((Iterator)this.myControlFlowGraph.getIn((Object)instruction), it -> this.myInstruction2NNumber.getInt(it) < this.myInstruction2NNumber.getInt((Object)instruction));
        if (iterator == null) {
            SymbolicExecutionEngineImpl.$$$reportNull$$$0(6);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExecution";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/SymbolicExecutionEngineImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/SymbolicExecutionEngineImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessorsWithoutBackEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performSymbolicExecution";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessorsWithoutBackEdges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

