/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicContextComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.PsiStringValueVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class ConstantStringInferenceComponent
implements SymbolicContextComponent {
    @NotNull
    private final Map<SymbolicExpression, StringValue> myExpressionToStringValue;
    @NotNull
    private final SymbolicExpressionProvider mySymbolicExpressionProvider;

    public ConstantStringInferenceComponent(@NotNull SymbolicExpressionProvider provider) {
        if (provider == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(0);
        }
        this.myExpressionToStringValue = new HashMap<SymbolicExpression, StringValue>();
        this.mySymbolicExpressionProvider = provider;
    }

    private ConstantStringInferenceComponent(@NotNull Map<SymbolicExpression, StringValue> stringValueMap, @NotNull SymbolicExpressionProvider provider) {
        if (stringValueMap == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(2);
        }
        this.myExpressionToStringValue = stringValueMap;
        this.mySymbolicExpressionProvider = provider;
    }

    public SymbolicContextComponent copy() {
        return new ConstantStringInferenceComponent(new HashMap<SymbolicExpression, StringValue>(this.myExpressionToStringValue), this.mySymbolicExpressionProvider);
    }

    public SymbolicContextComponent join(@NotNull SymbolicContextComponent another) {
        if (another == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(3);
        }
        HashMap<SymbolicExpression, StringValue> jointStringValueMap = new HashMap<SymbolicExpression, StringValue>();
        Map<SymbolicExpression, StringValue> anotherStringValueMap = ((ConstantStringInferenceComponent)another).myExpressionToStringValue;
        for (SymbolicExpression key : Sets.union(this.myExpressionToStringValue.keySet(), anotherStringValueMap.keySet())) {
            StringValue myValue = this.myExpressionToStringValue.get(key);
            StringValue anotherValue = anotherStringValueMap.get(key);
            if (myValue == null) {
                jointStringValueMap.put(key, anotherValue);
                continue;
            }
            if (anotherValue == null) {
                jointStringValueMap.put(key, myValue);
                continue;
            }
            jointStringValueMap.put(key, StringValueUtil.createStringValueUnion(Arrays.asList(myValue, anotherValue)));
        }
        return new ConstantStringInferenceComponent(jointStringValueMap, this.mySymbolicExpressionProvider);
    }

    public void fun(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpressionProvider symbolicExpressionProvider, @NotNull Instruction instruction) {
        PsiElement psiElement;
        if (context == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(4);
        }
        if (symbolicExpressionProvider == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(5);
        }
        if (instruction == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(6);
        }
        if ((psiElement = instruction.getElement()) instanceof RPsiElement) {
            RPsiElement element = (RPsiElement)psiElement;
            SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression(element, context);
            this.processElement(element, expression, context);
            if (element instanceof RPossibleCall) {
                this.processCall((RPossibleCall)element, context);
            }
        }
    }

    @Nullable
    public StringValue getStringRepresentation(@NotNull SymbolicExpression expression) {
        if (expression == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(7);
        }
        return this.myExpressionToStringValue.get(expression);
    }

    private void processElement(@NotNull RPsiElement element, @NotNull SymbolicExpression expression, @NotNull SymbolicExecutionContext context) {
        StringValue result;
        if (element == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(10);
        }
        if (this.myExpressionToStringValue.containsKey(expression)) {
            return;
        }
        if (expression instanceof MergedSymbolicExpression) {
            ArrayList<StringValue> stringValues = new ArrayList<StringValue>();
            for (SymbolicExpression component : expression.getChildren()) {
                StringValue stringValue = this.getStringRepresentation(component);
                if (stringValue == null) continue;
                stringValues.add(stringValue);
            }
            result = StringValueUtil.createStringValueUnion(stringValues);
        } else {
            Function<RPsiElement, StringValue> elementToStringValue = elem -> this.getStringRepresentation(this.mySymbolicExpressionProvider.getSymbolicExpression(elem, context));
            result = PsiStringValueVisitor.inferStringValue(element, elementToStringValue);
        }
        if (result != null) {
            this.myExpressionToStringValue.put(expression, result);
        }
    }

    private void processCall(@NotNull RPossibleCall element, @NotNull SymbolicExecutionContext context) {
        if (element == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(12);
        }
        if ("each".equals(element.getCommand())) {
            RPsiElement receiver = element.getReceiver();
            if (receiver == null) {
                return;
            }
            RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)element);
            if (blockCall == null) {
                return;
            }
            StringValue stringValue = this.getStringRepresentation(this.mySymbolicExpressionProvider.getSymbolicExpression(receiver, context));
            RBlockArgumentList blockArguments = blockCall.getBlock().getBlockArguments();
            if (blockArguments == null) {
                this.processNumberedArguments(blockCall, context, stringValue);
                return;
            }
            List arguments = blockArguments.getArguments();
            int numberParameters = arguments.size();
            if (numberParameters == 0) {
                return;
            }
            for (int i = 0; i < numberParameters; ++i) {
                RArgument argument = (RArgument)arguments.get(i);
                String argumentName = argument.getName();
                SymbolicExpression argumentExpression = this.mySymbolicExpressionProvider.createSymbolicVariable();
                context.getLocalMemory().writeLocalValue(argumentName, argumentExpression);
                ArrayList argumentValueList = new ArrayList();
                StringValueUtil.appendStringValueArrayLists((StringValue)stringValue, argumentValueList, (int)i, (int)numberParameters);
                this.myExpressionToStringValue.put(argumentExpression, StringValueUtil.createStringValueUnion(argumentValueList));
            }
        }
    }

    private void processNumberedArguments(@NotNull RBlockCall blockCall, @NotNull SymbolicExecutionContext context, @Nullable StringValue stringValue) {
        List<RIdentifier> substitutionIdentifiers;
        if (blockCall == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ConstantStringInferenceComponent.$$$reportNull$$$0(14);
        }
        if ((substitutionIdentifiers = PsiTreeUtil.findChildrenOfType((PsiElement)blockCall, RExpressionSubstitution.class).stream().map(it -> (RIdentifier)PsiTreeUtil.findChildOfType((PsiElement)it, RIdentifier.class)).filter(Objects::nonNull).filter(it -> it.getName() != null && it.getName().matches("_\\d+")).toList()).isEmpty()) {
            return;
        }
        int numberOfParameters = substitutionIdentifiers.stream().map(it -> Integer.parseInt(Objects.requireNonNull(it.getName()).substring(1))).max(Integer::compareTo).orElse(-1);
        for (RIdentifier identifier : substitutionIdentifiers) {
            String name = Objects.requireNonNull(identifier.getName());
            int parameterIndex = Integer.parseInt(name.substring(1)) - 1;
            if (parameterIndex < 0) continue;
            SymbolicExpression argumentExpression = this.mySymbolicExpressionProvider.createSymbolicVariable();
            context.getLocalMemory().writeLocalValue(name, argumentExpression);
            ArrayList argumentValueList = new ArrayList();
            StringValueUtil.appendStringValueArrayLists((StringValue)stringValue, argumentValueList, (int)parameterIndex, (int)numberOfParameters);
            this.myExpressionToStringValue.put(argumentExpression, StringValueUtil.createStringValueUnion(argumentValueList));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValueMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExpressionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/ConstantStringInferenceComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "join";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fun";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringRepresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processCall";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processNumberedArguments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

