/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.impl;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.map.DFAMap;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.impl.LocalVariableDeclarationVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.impl.ScopeVariableImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.dataFlow.reachingDefs.RReachingDefsDfaInstance;
import org.jetbrains.plugins.ruby.ruby.lang.psi.dataFlow.reachingDefs.RReachingDefsSemilattice;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RPredefinedArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public class ScopeImpl
implements Scope {
    private final ScopeHolder myHolder;
    private final RControlFlow myFlow;
    private volatile List<DFAMap<ScopeVariable>> myCachedScopeVariables = null;
    private final NotNullLazyValue<Map<String, PsiElement>> myCachedLocalVariableDeclarations;

    public ScopeImpl(ScopeHolder holder) {
        this.myHolder = holder;
        this.myCachedLocalVariableDeclarations = NotNullLazyValue.createValue(() -> this.myHolder.getVariableDeclarations());
        this.myFlow = this.myHolder.getControlFlow();
    }

    @NotNull
    public Collection<ScopeVariable> getDeclaredVariables(@NotNull PsiElement anchorElement) {
        if (anchorElement == null) {
            ScopeImpl.$$$reportNull$$$0(0);
        }
        this.computeScopeVariables();
        int instructionNum = this.elementToInstructionNum(anchorElement);
        if (instructionNum < 0) {
            List<ScopeVariable> list = Collections.emptyList();
            if (list == null) {
                ScopeImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection collection = this.myCachedScopeVariables.get(instructionNum).values();
        if (collection == null) {
            ScopeImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public ScopeVariable getDeclaredVariable(@NotNull PsiElement anchorElement, @NotNull String name) {
        if (anchorElement == null) {
            ScopeImpl.$$$reportNull$$$0(3);
        }
        if (name == null) {
            ScopeImpl.$$$reportNull$$$0(4);
        }
        this.computeScopeVariables();
        int instructionNum = this.elementToInstructionNum(anchorElement);
        if (instructionNum < 0) {
            return null;
        }
        return (ScopeVariable)this.myCachedScopeVariables.get(instructionNum).get(name);
    }

    @Nullable
    public ScopeVariable getDeclaredVariable(@NotNull Instruction anchorInstruction, @NotNull String name) {
        if (anchorInstruction == null) {
            ScopeImpl.$$$reportNull$$$0(5);
        }
        if (name == null) {
            ScopeImpl.$$$reportNull$$$0(6);
        }
        this.computeScopeVariables();
        int instructionNum = anchorInstruction.num();
        if (this.myFlow.getInstructions()[instructionNum].getElement() != anchorInstruction.getElement()) {
            return null;
        }
        return (ScopeVariable)this.myCachedScopeVariables.get(instructionNum).get(name);
    }

    private int elementToInstructionNum(@NotNull PsiElement element) {
        Instruction instruction;
        if (element == null) {
            ScopeImpl.$$$reportNull$$$0(7);
        }
        return (instruction = this.myFlow.getInstructionByElement(element)) == null ? -1 : instruction.num();
    }

    @NotNull
    public List<DFAMap<ScopeVariable>> computeScopeVariables() {
        if (this.myHolder instanceof RCodeBlock) {
            RContainer container = this.myHolder.getParentContainer();
            Objects.requireNonNull(container, "element should have a parent container");
            ScopeImpl outerScope = (ScopeImpl)container.getScope();
            outerScope.computeScopesIfAbsent();
            if (this.myCachedScopeVariables == null) {
                this.computeScopesIfAbsent();
            }
        } else {
            this.computeScopesIfAbsent();
        }
        List<DFAMap<ScopeVariable>> list = this.myCachedScopeVariables;
        if (list == null) {
            ScopeImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public PsiElement getLocalVariable(@NotNull PsiElement anchorElement, @NotNull String name) {
        if (anchorElement == null) {
            ScopeImpl.$$$reportNull$$$0(9);
        }
        if (name == null) {
            ScopeImpl.$$$reportNull$$$0(10);
        }
        return ScopeUtilCore.getLocalVariable(this.myHolder, anchorElement, name, (Map)this.myCachedLocalVariableDeclarations.getValue());
    }

    public List<PsiElement> getLocalVariables(@NotNull PsiElement scope, @NotNull PsiElement anchor) {
        if (scope == null) {
            ScopeImpl.$$$reportNull$$$0(11);
        }
        if (anchor == null) {
            ScopeImpl.$$$reportNull$$$0(12);
        }
        Map declarations = (Map)this.myCachedLocalVariableDeclarations.getValue();
        return ContainerUtil.filter(declarations.values(), element -> {
            RArgument argument;
            RIdentifier identifier;
            if (element instanceof RIdentifier && LocalVariableDeclarationVisitor.isNumberedParameter(this.myHolder, identifier = (RIdentifier)element)) {
                return false;
            }
            if (!RubyPsiUtilCore.isBefore(element, anchor)) {
                return false;
            }
            return !RubyPsiUtilCore.getLanguageLevel(anchor).isLessThan(LanguageLevel.RUBY27) || (argument = RPredefinedArgumentNavigator.getByDeclaredElement(element)) == null || !PsiTreeUtil.isAncestor((PsiElement)argument.getValue(), (PsiElement)anchor, (boolean)false);
        });
    }

    @NotNull
    public List<RIdentifier> getNumberedParameters(@NotNull PsiElement scope) {
        if (scope == null) {
            ScopeImpl.$$$reportNull$$$0(13);
        }
        Map declarations = (Map)this.myCachedLocalVariableDeclarations.getValue();
        List<RIdentifier> list = declarations.values().stream().mapMulti(StreamUtil.select(RIdentifier.class, (Class[])new Class[0])).filter(identifier -> LocalVariableDeclarationVisitor.isNumberedParameter(this.myHolder, identifier)).toList();
        if (list == null) {
            ScopeImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public Map<String, ScopeVariable> getOuterScopeVariables() {
        List<DFAMap<ScopeVariable>> scopeVariables = this.computeScopeVariables();
        if (scopeVariables.isEmpty()) {
            return Collections.emptyMap();
        }
        return scopeVariables.get(0).toMap();
    }

    @NotNull
    public List<String> getScopeVariableNames(@NotNull PsiElement anchorElement) {
        if (anchorElement == null) {
            ScopeImpl.$$$reportNull$$$0(15);
        }
        Map allVariablesInScope = (Map)this.myCachedLocalVariableDeclarations.getValue();
        List<String> list = allVariablesInScope.entrySet().stream().filter(entry -> ((PsiElement)entry.getValue()).getTextOffset() <= anchorElement.getTextOffset()).map(Map.Entry::getKey).toList();
        if (list == null) {
            ScopeImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<String> getAllScopeVariableNames() {
        List<String> list = List.copyOf(((Map)this.myCachedLocalVariableDeclarations.getValue()).keySet());
        if (list == null) {
            ScopeImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public Map<String, ScopeVariable> getAllDeclaredVariables() {
        this.computeScopeVariables();
        Map map = this.myCachedScopeVariables.get(this.myFlow.getInstructions().length - 1).toMap();
        if (map == null) {
            ScopeImpl.$$$reportNull$$$0(18);
        }
        return map;
    }

    private synchronized void computeScopesIfAbsent() {
        if (this.myCachedScopeVariables == null) {
            MyTraversalResults results = new MyTraversalResults();
            ScopeImpl.traverse(this, ScopeUtilCore.EMPTY_SCOPE, results, true);
            ScopeImpl.traverse(this, ScopeUtilCore.EMPTY_SCOPE, results, false);
        }
    }

    @NotNull
    private static DFAMap<ScopeVariable> mergeCodeBlockExitState(@NotNull DFAMap<ScopeVariable> currentState, @NotNull DFAMap<ScopeVariable> codeBlockExitState, @NotNull RCodeBlock codeBlock) {
        PsiElement codeBlockScope;
        if (currentState == null) {
            ScopeImpl.$$$reportNull$$$0(19);
        }
        if (codeBlockExitState == null) {
            ScopeImpl.$$$reportNull$$$0(20);
        }
        if (codeBlock == null) {
            ScopeImpl.$$$reportNull$$$0(21);
        }
        if (!((codeBlockScope = codeBlock.getParent()) instanceof RLambda)) {
            codeBlockScope = null;
        }
        DFAMap newState = new DFAMap();
        for (ScopeVariable currentStateVariable : currentState.values()) {
            String variableName = currentStateVariable.getName();
            ScopeVariable blockVariable = (ScopeVariable)codeBlockExitState.get(variableName);
            if (currentStateVariable.getScope() == codeBlockScope) continue;
            if (currentStateVariable.isSame(blockVariable)) {
                HashSet<RPsiElement> declarations = new HashSet<RPsiElement>(currentStateVariable.getDeclarations());
                declarations.addAll(blockVariable.getDeclarations());
                currentStateVariable = new ScopeVariableImpl(variableName, currentStateVariable.getType() == Type.METHOD_PARAMETER, currentStateVariable.getScope(), declarations, currentStateVariable.getFirstDeclaration(), true, false);
            }
            newState.put(variableName, (Object)currentStateVariable);
        }
        DFAMap dFAMap = newState;
        if (dFAMap == null) {
            ScopeImpl.$$$reportNull$$$0(22);
        }
        return dFAMap;
    }

    @Nullable
    private static DFAMap<ScopeVariable> computeInboundState(@NotNull ScopeImpl scope, @NotNull Instruction instruction, @NotNull List<DFAMap<ScopeVariable>> instructionStates, boolean addBackEdges, @NotNull BitSet instructionProcessingStates) {
        if (scope == null) {
            ScopeImpl.$$$reportNull$$$0(23);
        }
        if (instruction == null) {
            ScopeImpl.$$$reportNull$$$0(24);
        }
        if (instructionStates == null) {
            ScopeImpl.$$$reportNull$$$0(25);
        }
        if (instructionProcessingStates == null) {
            ScopeImpl.$$$reportNull$$$0(26);
        }
        Collection directPreviousInstructions = instruction.allPred();
        ArrayList<DFAMap<ScopeVariable>> previousInstructionsStates = new ArrayList<DFAMap<ScopeVariable>>();
        int instructionNum = instruction.num();
        boolean isCodeBlock = instruction.getElement() instanceof RCodeBlock;
        if (!directPreviousInstructions.iterator().hasNext()) {
            instructionProcessingStates.set(instructionNum);
            return null;
        }
        if (addBackEdges && isCodeBlock) {
            previousInstructionsStates.add(instructionStates.get(instructionNum));
        }
        for (Instruction directPreviousInstruction : directPreviousInstructions) {
            if ((addBackEdges || directPreviousInstruction.num() < instructionNum) && scope.myFlow.isReachable(directPreviousInstruction)) {
                previousInstructionsStates.add(instructionStates.get(directPreviousInstruction.num()));
                continue;
            }
            isCodeBlock = true;
        }
        instructionProcessingStates.set(instructionNum, !isCodeBlock);
        return RReachingDefsSemilattice.merge(previousInstructionsStates);
    }

    @NotNull
    private static DFAMap<ScopeVariable> traverse(@NotNull ScopeImpl scope, @NotNull DFAMap<ScopeVariable> initialState, @NotNull MyTraversalResults results, boolean isFirstTraversal) {
        BitSet instructionProcessingStates;
        ArrayList<DFAMap<ScopeVariable>> instructionStates;
        DFAMap result;
        if (scope == null) {
            ScopeImpl.$$$reportNull$$$0(27);
        }
        if (initialState == null) {
            ScopeImpl.$$$reportNull$$$0(28);
        }
        if (results == null) {
            ScopeImpl.$$$reportNull$$$0(29);
        }
        if ((result = isFirstTraversal ? (DFAMap)ContainerUtil.getLastItem(results.instructionDfaVariables.getOrDefault(scope, Collections.emptyList())) : (DFAMap)ContainerUtil.getLastItem((List)((List)ObjectUtils.coalesce(scope.myCachedScopeVariables, Collections.emptyList())))) != null) {
            DFAMap dFAMap = result;
            if (dFAMap == null) {
                ScopeImpl.$$$reportNull$$$0(30);
            }
            return dFAMap;
        }
        Instruction[] instructions = scope.myFlow.getInstructions();
        int cfgLength = instructions.length;
        if (isFirstTraversal) {
            instructionStates = new ArrayList<DFAMap<ScopeVariable>>(cfgLength);
            instructionProcessingStates = new BitSet(cfgLength);
        } else {
            instructionStates = new ArrayList(Objects.requireNonNull(results.instructionDfaVariables.get(scope)));
            instructionProcessingStates = Objects.requireNonNull(results.instructionProcessingStates.get(scope));
            if (!RReachingDefsSemilattice.eq(initialState, (DFAMap<ScopeVariable>)((DFAMap)instructionStates.get(0)))) {
                instructionProcessingStates.clear(0);
            }
        }
        DFAMap<ScopeVariable> currentInstructionState = new DFAMap<ScopeVariable>(initialState);
        for (int i = 0; i < cfgLength; ++i) {
            boolean hasChanged;
            ProgressManager.checkCanceled();
            if (instructionProcessingStates.get(i)) continue;
            Instruction instruction = instructions[i];
            RPsiElement element = (RPsiElement)instruction.getElement();
            DFAMap<ScopeVariable> inboundState = ScopeImpl.computeInboundState(scope, instruction, instructionStates, !isFirstTraversal, instructionProcessingStates);
            if (inboundState != null) {
                currentInstructionState = inboundState;
            }
            if (element instanceof RCodeBlock) {
                RCodeBlock rCodeBlock = (RCodeBlock)element;
                ScopeImpl codeBlockScope = (ScopeImpl)rCodeBlock.getScope();
                DFAMap<ScopeVariable> codeBlockExitState = ScopeImpl.traverse(codeBlockScope, currentInstructionState, results, isFirstTraversal);
                currentInstructionState = ScopeImpl.mergeCodeBlockExitState(currentInstructionState, codeBlockExitState, rCodeBlock);
            } else {
                currentInstructionState = RReachingDefsDfaInstance.processInstruction(currentInstructionState, instruction, element);
            }
            if (isFirstTraversal) {
                instructionStates.add(currentInstructionState);
                continue;
            }
            boolean bl = hasChanged = !RReachingDefsSemilattice.eq((DFAMap<ScopeVariable>)((DFAMap)instructionStates.get(i)), currentInstructionState);
            if (!hasChanged) continue;
            instructionStates.set(i, currentInstructionState);
            for (Instruction nextInstruction : instruction.allSucc()) {
                instructionProcessingStates.clear(nextInstruction.num());
            }
        }
        if (isFirstTraversal) {
            results.instructionDfaVariables.put(scope, instructionStates);
            results.instructionProcessingStates.put(scope, instructionProcessingStates);
        } else {
            scope.myCachedScopeVariables = instructionStates;
        }
        DFAMap dFAMap = (DFAMap)instructionStates.get(cfgLength - 1);
        if (dFAMap == null) {
            ScopeImpl.$$$reportNull$$$0(31);
        }
        return dFAMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 14, 16, 17, 18, 22, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/impl/ScopeImpl";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorInstruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 13: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlockExitState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionStates";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionProcessingStates";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/impl/ScopeImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeScopeVariables";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberedParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeVariableNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScopeVariableNames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeclaredVariables";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCodeBlockExitState";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredVariables";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 30: 
            case 31: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "elementToInstructionNum";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalVariable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocalVariables";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNumberedParameters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getScopeVariableNames";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mergeCodeBlockExitState";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeInboundState";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 14, 16, 17, 18, 22, 30, 31 -> new IllegalStateException(string);
        };
    }

    private record MyTraversalResults(Map<Scope, List<DFAMap<ScopeVariable>>> instructionDfaVariables, Map<Scope, BitSet> instructionProcessingStates) {
        private MyTraversalResults() {
            this(new HashMap<Scope, List<DFAMap<ScopeVariable>>>(), new HashMap<Scope, BitSet>());
        }
    }
}

