/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.dataflow.map.DFAMap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsoleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyDataKeys;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.impl.LocalVariableDeclarationVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RPredefinedArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class ScopeUtilCore {
    public static final DFAMap<ScopeVariable> EMPTY_SCOPE = new DFAMap();

    private ScopeUtilCore() {
    }

    public static RPsiElement getScopeElement(PsiElement element) {
        return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{ScopeHolder.class, RCodeBlock.class, RLambda.class});
    }

    public static RPsiElement getParameterScope(RPsiElement element) {
        RPsiElement scope = RubyUsageAnalyzerCore.getParameterScope(element);
        while (scope instanceof RForStatement || scope instanceof RRescueBlock) {
            scope = ScopeUtilCore.getScopeElement((PsiElement)scope);
        }
        return scope;
    }

    @Nullable
    public static PsiElement getLocalVariable(@NotNull ScopeHolder scopeHolder, @NotNull PsiElement anchorElement, @NotNull String name, @NotNull Map<String, PsiElement> implicitDeclarations) {
        PsiElement anchor;
        RIdentifier identifier;
        PsiElement declaration;
        if (scopeHolder == null) {
            ScopeUtilCore.$$$reportNull$$$0(0);
        }
        if (anchorElement == null) {
            ScopeUtilCore.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ScopeUtilCore.$$$reportNull$$$0(2);
        }
        if (implicitDeclarations == null) {
            ScopeUtilCore.$$$reportNull$$$0(3);
        }
        if ((declaration = implicitDeclarations.get(name)) == null || declaration instanceof RIdentifier && LocalVariableDeclarationVisitor.isNumberedParameter(scopeHolder, identifier = (RIdentifier)declaration)) {
            return null;
        }
        for (anchor = anchorElement; anchor != null && !anchor.getContainingFile().equals((Object)scopeHolder.getContainingFile()); anchor = anchor.getContext()) {
        }
        if (anchor == null) {
            return declaration;
        }
        int offset = (Integer)ObjectUtils.coalesce((Object)((Integer)anchor.getCopyableUserData(RubyDataKeys.RUBY_CONSOLE_CONTEXT_OFFSET_KEY)), (Object)-1);
        if (offset >= 0) {
            anchor = (PsiElement)ObjectUtils.coalesce((Object)((PsiElement)ContainerUtil.find((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)anchor, PsiElement.class), it -> it.getTextOffset() >= offset)), (Object)anchor);
        }
        if (!RubyPsiUtilCore.isBefore(declaration, anchor)) {
            return null;
        }
        RArgument argument = RPredefinedArgumentNavigator.getByDeclaredElement(declaration);
        if (argument != null && PsiTreeUtil.isAncestor((PsiElement)argument.getValue(), (PsiElement)anchor, (boolean)false) && RubyPsiUtilCore.getLanguageLevel(anchor).isLessThan(LanguageLevel.RUBY27)) {
            return null;
        }
        return declaration;
    }

    @Nullable
    public static ScopeHolder findScopeHolder(@NotNull PsiElement element) {
        RSuperClass superClass;
        if (element == null) {
            ScopeUtilCore.$$$reportNull$$$0(4);
        }
        if (!element.isValid()) {
            return null;
        }
        if (element instanceof RubyExpressionCodeFragment) {
            return (ScopeHolder)ObjectUtils.doIfNotNull((Object)CompletionUtil.getOriginalOrSelf((PsiElement)element).getContext(), ScopeUtilCore::findScopeHolder);
        }
        if (element instanceof RFile && RubyLanguageConsoleUtil.isInLanguageConsole(element)) {
            return (ScopeHolder)ObjectUtils.doIfNotNull((Object)RubyLanguageConsoleUtil.getLanguageConsoleContext(element), ScopeUtilCore::findScopeHolder);
        }
        ScopeHolder holder = (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeHolder.class);
        if (holder instanceof RSingletonMethod && PsiTreeUtil.getParentOfType((PsiElement)element, RClassObject.class) == ((RSingletonMethod)holder).getClassObject()) {
            return (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)holder, ScopeHolder.class);
        }
        if (holder instanceof RClass && (superClass = ((RClass)holder).getPsiSuperClass()) != null && PsiTreeUtil.getParentOfType((PsiElement)element, RSuperClass.class) == superClass) {
            return (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)holder, ScopeHolder.class);
        }
        if (holder instanceof RObjectClass && PsiTreeUtil.getParentOfType((PsiElement)element, RClassObject.class) == ((RObjectClass)holder).getObject()) {
            return (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)holder, ScopeHolder.class);
        }
        return holder;
    }

    @Nullable
    public static Scope getScope(@NotNull RPsiElement element) {
        ScopeHolder holder;
        if (element == null) {
            ScopeUtilCore.$$$reportNull$$$0(5);
        }
        return (holder = ScopeUtilCore.findScopeHolder((PsiElement)element)) != null ? holder.getScope() : null;
    }

    public static boolean hasParentScopeHolder(@NotNull PsiElement element) {
        if (element == null) {
            ScopeUtilCore.$$$reportNull$$$0(6);
        }
        return element instanceof RCodeBlock || element instanceof RLambda || element instanceof RubyExpressionCodeFragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/ScopeUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalVariable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findScopeHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasParentScopeHolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

