/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RangeInDocumentFakePsiElement
extends FakePsiElement
implements RPsiElement {
    @Nullable
    private final PsiFileStub<? extends PsiFile> myFileStub;
    @Nullable
    private volatile PsiElement myParent;
    @NotNull
    private volatile TextRange myRangeInParent;

    public RangeInDocumentFakePsiElement(@NotNull Surrogate s) {
        if (s == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(0);
        }
        this.myFileStub = s.myFileStub;
        this.myParent = s.myParent;
        this.myRangeInParent = s.myRangeInParent;
    }

    public RangeInDocumentFakePsiElement(@NotNull PsiElement parent, @NotNull TextRange rangeInParent) {
        if (parent == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(1);
        }
        if (rangeInParent == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(2);
        }
        this.myFileStub = null;
        this.myParent = parent;
        this.myRangeInParent = rangeInParent;
    }

    public RangeInDocumentFakePsiElement(@NotNull PsiFileStub<? extends PsiFile> fileStub, @NotNull TextRange rangeInParent) {
        if (fileStub == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(3);
        }
        if (rangeInParent == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(4);
        }
        this.myFileStub = fileStub;
        this.myParent = null;
        this.myRangeInParent = rangeInParent;
    }

    public PsiManager getManager() {
        PsiFile containingFile = this.getContainingFile();
        if (containingFile != null) {
            return containingFile.getManager();
        }
        return super.getManager();
    }

    public PsiFile getContainingFile() {
        return this.myFileStub != null ? (PsiFile)this.myFileStub.getPsi() : super.getContainingFile();
    }

    public final PsiElement getParent() {
        if (this.myParent != null) {
            return this.myParent;
        }
        this.myParent = this.computeParent();
        return this.myParent;
    }

    public boolean isValid() {
        if (this.myParent != null) {
            return this.myParent.isValid();
        }
        assert (this.myFileStub != null);
        PsiFile filePsi = (PsiFile)this.myFileStub.getPsi();
        return filePsi != null && filePsi.isValid();
    }

    public int getTextLength() {
        return this.myRangeInParent.getLength();
    }

    @NotNull
    public String getText() {
        String text = this.getParent().getText();
        String string = this.myRangeInParent.substring(text);
        if (string == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement parent;
        if (name == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(7);
        }
        if (!((parent = this.getParent()) instanceof PsiComment)) {
            return super.setName(name);
        }
        PsiComment comment = RubyElementFactoryCore.createPsiComment(parent.getProject(), this.myRangeInParent.replace(parent.getText(), name));
        parent.replace((PsiElement)comment);
        this.myParent = comment;
        return comment;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myParent == null) {
            TextRange textRange = this.myRangeInParent;
            if (textRange == null) {
                RangeInDocumentFakePsiElement.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        TextRange textRange = this.myRangeInParent.shiftRight(this.getParent().getTextRange().getStartOffset());
        if (textRange == null) {
            RangeInDocumentFakePsiElement.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    public int getTextOffset() {
        if (this.myParent == null) {
            return this.myRangeInParent.getStartOffset();
        }
        return this.getParent().getTextRange().getStartOffset() + this.myRangeInParent.getStartOffset();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (!(another instanceof RangeInDocumentFakePsiElement)) {
            return false;
        }
        return another.getContainingFile().isEquivalentTo((PsiElement)this.getContainingFile()) && this.getTextRange().equals((Object)another.getTextRange());
    }

    public int getStartOffsetInParent() {
        this.getParent();
        return this.myRangeInParent.getStartOffset();
    }

    @Nullable
    public RContainer getParentContainer() {
        return (RContainer)PsiTreeUtil.getParentOfType((PsiElement)this, RContainer.class);
    }

    @Nullable
    public LanguageLevel getLanguageLevel() {
        RPsiElement element = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)this, RPsiElement.class, (boolean)true);
        if (element == null) {
            return null;
        }
        return element.getLanguageLevel();
    }

    public String toString() {
        if (this.myParent == null) {
            return "FakePsi:(stub." + String.valueOf(this.myFileStub) + ";" + String.valueOf(this.myRangeInParent) + ")";
        }
        return "FakePsi:(parent." + String.valueOf(this.myParent) + ";" + String.valueOf(this.myRangeInParent) + ";" + this.myRangeInParent.substring(this.myParent.getText()) + ")";
    }

    @Nullable
    private synchronized PsiElement computeParent() {
        PsiElement commonParent;
        if (this.myParent != null) {
            return this.myParent;
        }
        assert (this.myFileStub != null);
        PsiFile file = (PsiFile)this.myFileStub.getPsi();
        if (file == null) {
            return null;
        }
        PsiElement firstElement = file.findElementAt(this.myRangeInParent.getStartOffset());
        PsiElement secondElement = file.findElementAt(this.myRangeInParent.getEndOffset() - 1);
        if (firstElement != null && secondElement != null && (commonParent = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)secondElement)) != null) {
            this.myParent = commonParent;
            this.myRangeInParent = this.myRangeInParent.shiftRight(-commonParent.getTextRange().getStartOffset());
            return this.myParent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInParent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStub";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/psi/RangeInDocumentFakePsiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/psi/RangeInDocumentFakePsiElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static final class Surrogate {
        @Nullable
        PsiFileStub<? extends PsiFile> myFileStub;
        @Nullable
        PsiElement myParent;
        @NotNull
        TextRange myRangeInParent;

        public Surrogate(@Nullable PsiFileStub<? extends PsiFile> fileStub, @Nullable PsiElement parent, @NotNull TextRange rangeInParent) {
            if (rangeInParent == null) {
                Surrogate.$$$reportNull$$$0(0);
            }
            this.myFileStub = fileStub;
            this.myParent = parent;
            this.myRangeInParent = rangeInParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInParent", "org/jetbrains/plugins/ruby/rdoc/yard/psi/RangeInDocumentFakePsiElement$Surrogate", "<init>"));
        }
    }
}

