/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDLexer;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.YARDFakePsiFactory;

public class YARDPsiLexer
extends YARDLexer {
    private final List<? extends PsiComment> myComments;
    private final int[] myIndents;
    private final PsiElement myCommentsParent;

    public YARDPsiLexer(List<? extends PsiComment> comments) {
        super(true);
        this.myComments = comments;
        this.myCommentsParent = this.myComments.isEmpty() ? null : this.myComments.get(0).getParent();
        this.myIndents = new int[comments.size()];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < comments.size(); ++i) {
            String content = comments.get(i).getText().substring(1);
            if (!builder.isEmpty()) {
                builder.append('\n');
            }
            this.myIndents[i] = builder.length();
            builder.append(content);
        }
        this.start(builder.toString());
    }

    public PsiElement getCommentsParent() {
        return this.myCommentsParent;
    }

    public int getOffsetInParent() {
        int[] psiStart = this.getPsiStart();
        PsiComment psiComment = this.myComments.get(psiStart[0]);
        return psiComment.getStartOffsetInParent() + psiStart[1] + 1;
    }

    @NotNull
    public <T extends RangeInDocumentFakePsiElement> T advanceAndCreateFakePsi(@NotNull YARDFakePsiFactory<T> factory) {
        if (factory == null) {
            YARDPsiLexer.$$$reportNull$$$0(0);
        }
        PsiComment comment = this.myComments.get(this.getPsiStart()[0]);
        int position = this.getOffsetInParent();
        this.advance();
        T result = factory.createFakePsiElement((PsiElement)comment, TextRange.create((int)position, (int)this.getOffsetInParent()).shiftRight(-comment.getStartOffsetInParent()));
        this.passEols();
        T t = result;
        if (t == null) {
            YARDPsiLexer.$$$reportNull$$$0(1);
        }
        return t;
    }

    public int[] getPsiStart() {
        int tokenStart = super.getTokenStart();
        int i = YARDPsiLexer.find(this.myIndents, tokenStart);
        return new int[]{i, tokenStart - this.myIndents[i]};
    }

    static int find(int[] indents, int offset) {
        int i = ObjectUtils.binarySearch((int)0, (int)indents.length, k -> indents[k] <= offset ? -1 : 1);
        return Math.max(0, -i - 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDPsiLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDPsiLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "advanceAndCreateFakePsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "advanceAndCreateFakePsi";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

