/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbFileViewProvider;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;

public final class ErbPsiUtil {
    private ErbPsiUtil() {
    }

    public static boolean isCodeInjectionStart(IElementType tokenType) {
        return ErbTokenTypes.ERB_SEPARATORS_STARTS.contains(tokenType);
    }

    public static boolean isCodeInjectionEnd(IElementType tokenType) {
        return ErbTokenTypes.ERB_SEPARATORS_ENDS.contains(tokenType);
    }

    public static boolean isTemplateLanguageRoot(PsiFile file) {
        FileViewProvider viewProvider = file.getViewProvider();
        if (!(viewProvider instanceof ErbFileViewProvider)) {
            return false;
        }
        return file.getLanguage() == ((ErbFileViewProvider)viewProvider).getTemplateDataLanguage();
    }

    @NotNull
    public static Collection<PsiElement> getElementsOfType(@NotNull Project project, @NotNull String fileText, @NotNull Class<? extends PsiElement> clazz) {
        PsiFile file;
        Collection elements;
        if (project == null) {
            ErbPsiUtil.$$$reportNull$$$0(0);
        }
        if (fileText == null) {
            ErbPsiUtil.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            ErbPsiUtil.$$$reportNull$$$0(2);
        }
        if (ContainerUtil.isEmpty((Collection)(elements = (file = ErbPsiUtil.createErbFile(project, fileText)) == null ? null : PsiTreeUtil.findChildrenOfType((PsiElement)file, clazz)))) {
            throw new RuntimeException("Failed to get " + clazz.getName() + " elements from text: " + fileText);
        }
        Collection collection = elements;
        if (collection == null) {
            ErbPsiUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public static PsiFile createErbFile(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            ErbPsiUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ErbPsiUtil.$$$reportNull$$$0(5);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("temp.erb", (Language)ErbLanguage.INSTANCE, (CharSequence)text);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        return ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).trySetupPsiForFile(virtualFile, (Language)ErbLanguage.INSTANCE, false, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/psi/ErbPsiUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/psi/ErbPsiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfType";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createErbFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

