/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.settings;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ui.FormBuilder;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class RubyCodeStyleGenerationConfigurable
implements CodeStyleConfigurable {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final JCheckBox parenthesesAroundMethodArgumentsCheckBox;
    @NotNull
    private final JCheckBox myConvertToDoEndBlockByEnterCheckBox;
    private final CodeStyleSettings mySettings;

    public RubyCodeStyleGenerationConfigurable(CodeStyleSettings settings) {
        this.mySettings = settings;
        FormBuilder builder = new FormBuilder();
        this.parenthesesAroundMethodArgumentsCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.parentheses.around.method.arguments", (Object[])new Object[0]));
        builder.addComponent((JComponent)this.parenthesesAroundMethodArgumentsCheckBox);
        this.myConvertToDoEndBlockByEnterCheckBox = new JCheckBox(RBundle.message((String)"ruby.code.style.convert.brace.block.by.enter"));
        builder.addComponent((JComponent)this.myConvertToDoEndBlockByEnterCheckBox);
        this.myPanel = builder.getPanel();
        this.myPanel.setLayout((LayoutManager)new VerticalFlowLayout());
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.rubycodestyle";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.isModified(this.mySettings);
    }

    private boolean isModified(CodeStyleSettings settings) {
        RubyCodeStyleSettings rubyCodeStyleSettings = RubyCodeStyleSettings.getInstance((CodeStyleSettings)settings);
        return this.parenthesesAroundMethodArgumentsCheckBox.isSelected() != rubyCodeStyleSettings.PARENTHESES_AROUND_METHOD_ARGUMENTS || this.myConvertToDoEndBlockByEnterCheckBox.isSelected() != rubyCodeStyleSettings.CONVERT_BRACE_BLOCK_BY_ENTER;
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            RubyCodeStyleGenerationConfigurable.$$$reportNull$$$0(0);
        }
        RubyCodeStyleSettings rubyCodeStyleSettings = RubyCodeStyleSettings.getInstance((CodeStyleSettings)settings);
        rubyCodeStyleSettings.PARENTHESES_AROUND_METHOD_ARGUMENTS = this.parenthesesAroundMethodArgumentsCheckBox.isSelected();
        rubyCodeStyleSettings.CONVERT_BRACE_BLOCK_BY_ENTER = this.myConvertToDoEndBlockByEnterCheckBox.isSelected();
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            RubyCodeStyleGenerationConfigurable.$$$reportNull$$$0(1);
        }
        RubyCodeStyleSettings rubyCodeStyleSettings = RubyCodeStyleSettings.getInstance((CodeStyleSettings)settings);
        this.parenthesesAroundMethodArgumentsCheckBox.setSelected(rubyCodeStyleSettings.PARENTHESES_AROUND_METHOD_ARGUMENTS);
        this.myConvertToDoEndBlockByEnterCheckBox.setSelected(rubyCodeStyleSettings.CONVERT_BRACE_BLOCK_BY_ENTER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "org/jetbrains/plugins/ruby/settings/RubyCodeStyleGenerationConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

