/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.regexp;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.regexp.Ruby19RegexpPropertiesProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyRegExpLanguageHost
implements RegExpLanguageHost {
    private static final EnumSet<RegExpGroup.Type> SUPPORTED_NAMED_GROUP_TYPES = EnumSet.of(RegExpGroup.Type.NAMED_GROUP, RegExpGroup.Type.QUOTED_NAMED_GROUP);
    final Ruby19RegexpPropertiesProvider myPropertiesProvider = Ruby19RegexpPropertiesProvider.getInstance();

    public boolean characterNeedsEscaping(char c, boolean isInClass) {
        return c == '/' || c == ']';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    public boolean supportConditionalCondition(RegExpAtom condition) {
        if (condition instanceof RegExpGroup) {
            return false;
        }
        IElementType type = condition.getNode().getFirstChildNode().getElementType();
        if (condition instanceof RegExpBackref) {
            return type == RegExpTT.ANGLE_BRACKET_CONDITION_BEGIN || type == RegExpTT.QUOTED_CONDITION_BEGIN;
        }
        return true;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        RegExpGroup.Type groupType = group.getType();
        return (groupType == RegExpGroup.Type.NAMED_GROUP || groupType == RegExpGroup.Type.QUOTED_NAMED_GROUP) && !RubyRegExpLanguageHost.isRuby18((RegExpElement)group);
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        if (RubyRegExpLanguageHost.isRuby18(context)) {
            EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
            if (enumSet == null) {
                RubyRegExpLanguageHost.$$$reportNull$$$0(0);
            }
            return enumSet;
        }
        EnumSet<RegExpGroup.Type> enumSet = SUPPORTED_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            RubyRegExpLanguageHost.$$$reportNull$$$0(1);
        }
        return enumSet;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isRubyNamedGroupRef() && !RubyRegExpLanguageHost.isRuby18((RegExpElement)ref);
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        if (regExpChar == null) {
            return false;
        }
        String text = regExpChar.getUnescapedText();
        return text.length() >= 2 && text.charAt(1) == 'u';
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            RubyRegExpLanguageHost.$$$reportNull$$$0(2);
        }
        return RegExpLanguageHost.Lookbehind.VARIABLE_LENGTH_ALTERNATION;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            RubyRegExpLanguageHost.$$$reportNull$$$0(3);
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    public Integer getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            RubyRegExpLanguageHost.$$$reportNull$$$0(4);
        }
        try {
            int result = Integer.parseInt(number.getUnescapedText());
            return result > 100000 ? null : Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return this.myPropertiesProvider.getAllKnownProperties();
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return this.myPropertiesProvider.getKnownCharacterClasses();
    }

    public boolean supportsBoundary(RegExpBoundary boundary) {
        RegExpBoundary.Type type = boundary.getType();
        if (type == RegExpBoundary.Type.RESET_MATCH) {
            LanguageLevel level = RubyRegExpLanguageHost.getLanguageLevel((RegExpElement)boundary);
            return level != null && level.isGreaterThan(LanguageLevel.RUBY19);
        }
        return type != RegExpBoundary.Type.UNICODE_EXTENDED_GRAPHEME;
    }

    private static boolean isRuby18(RegExpElement element) {
        LanguageLevel level = RubyRegExpLanguageHost.getLanguageLevel(element);
        return level != null && RubyVMOptions.getInstance().isRuby18Enabled(level);
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(RegExpElement element) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost((PsiElement)element);
        return host != null ? RubyPsiUtilCore.getLanguageLevel((PsiElement)host) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/regexp/RubyRegExpLanguageHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/regexp/RubyRegExpLanguageHost";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

