/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.actions.editor.handlers.RubyEnterHandlerUtil;
import org.jetbrains.plugins.ruby.ruby.actions.intention.blocks.BraceConverter;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public final class RubyBraceBlockEnterHandler
implements EnterHandlerDelegate,
RubyTokenTypes {
    private static final String NEWLINE = "\n";
    private static final Logger LOG = Logger.getInstance(RubyBraceBlockEnterHandler.class);

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(4);
        }
        return RubyBraceBlockEnterHandler.handleEnterInBraceBlock(dataContext, editor, file) ? EnterHandlerDelegate.Result.Stop : EnterHandlerDelegate.Result.Continue;
    }

    private static <T extends RCodeBlock> T getCodeBlockAt(@NotNull PsiFile file, int caret, @NotNull Class<T> codeBlockClass) {
        if (file == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(5);
        }
        if (codeBlockClass == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(6);
        }
        PsiElement elementAt = file.findElementAt(caret);
        return (T)((RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)elementAt, codeBlockClass));
    }

    static boolean handleEnterInBraceBlock(@NotNull DataContext dataContext, @NotNull Editor editor, @NotNull PsiFile file) {
        if (dataContext == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(9);
        }
        if (RubyBraceBlockEnterHandler.isAutoConversionOfBraceBlockDisabled(file)) {
            LOG.debug("Skipping conversion of brace block on enter, because it is disabled.");
            return false;
        }
        if (RubyBraceBlockEnterHandler.isAutoWrapInProgress(dataContext)) {
            LOG.debug("Skipping conversion of brace block on enter, because line wrapping is in progress.");
            return false;
        }
        int caret = editor.getCaretModel().getOffset();
        RBraceCodeBlock braceCodeBlock = RubyBraceBlockEnterHandler.getCodeBlockAt(file, caret, RBraceCodeBlock.class);
        if (braceCodeBlock == null || braceCodeBlock.getText().contains(NEWLINE)) {
            LOG.debug("Skipping conversion of brace block on enter, because one-line block is not found.");
            return false;
        }
        if (caret == braceCodeBlock.getTextOffset()) {
            LOG.debug("Skipping conversion of brace block on enter, because caret is not inside the braces.");
            return false;
        }
        RBlockArgumentList arguments = braceCodeBlock.getBlockArguments();
        if (arguments != null && caret <= arguments.getTextRange().getEndOffset()) {
            LOG.debug("Skipping conversion of brace block on enter, because caret is not after the block arguments.");
            return false;
        }
        if (RubyBraceBlockEnterHandler.isInsideAnotherCall((RCodeBlock)braceCodeBlock)) {
            LOG.debug("Skipping conversion of brace block on enter, because inside another call.");
            return false;
        }
        if (RubyPsiUtilCore.hasNonEditableFragment((Project)file.getProject(), (Document)editor.getDocument(), (PsiElement)braceCodeBlock)) {
            LOG.debug("Skipping conversion of brace block on enter, because there is a non editable fragment inside it.");
            return false;
        }
        RubyBraceBlockEnterHandler.performBraceBlockConversion(file, editor, braceCodeBlock, caret);
        return true;
    }

    private static void performBraceBlockConversion(@NotNull PsiFile file, @NotNull Editor editor, @NotNull RBraceCodeBlock braceCodeBlock, int caret) {
        if (file == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(11);
        }
        if (braceCodeBlock == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(12);
        }
        Project project = file.getProject();
        Document document = editor.getDocument();
        SmartPsiElementPointer braceCodeBlockPointer = SmartPointerManager.createPointer((PsiElement)braceCodeBlock);
        int line = document.getLineNumber(caret);
        boolean isMoveCaretAtEndOfLine = false;
        if (RubyBraceBlockEnterHandler.isCaretAfterBlockCompoundStatement(braceCodeBlock, caret)) {
            caret = braceCodeBlock.getCompoundStatement().getTextOffset();
            isMoveCaretAtEndOfLine = true;
        }
        document.insertString(braceCodeBlock.getLastChild().getTextOffset(), (CharSequence)NEWLINE);
        document.insertString(caret, (CharSequence)NEWLINE);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        if (braceCodeBlockPointer.getElement() == null) {
            LOG.warn("Aborting conversion of brace block on enter, because lost reference to the original block after document commit.");
            return;
        }
        BraceConverter.replaceBlock(project, braceCodeBlockPointer.getElement(), RBraceCodeBlock.class);
        RDoCodeBlock doBlock = RubyBraceBlockEnterHandler.getCodeBlockAt(file, caret, RDoCodeBlock.class);
        if (doBlock == null) {
            LOG.warn("Aborting conversion of brace block on enter, because conversion to do..end block failed.");
            return;
        }
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(doBlock.getNode().getTreeParent(), doBlock.getNode());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        RubyEnterHandlerUtil.indentLineAndMoveCaret((Project)project, (Editor)editor, (Document)document, (int)(line + 1), (boolean)isMoveCaretAtEndOfLine);
    }

    private static boolean isCaretAfterBlockCompoundStatement(@NotNull RBraceCodeBlock braceCodeBlock, int caret) {
        RCompoundStatement statement;
        if (braceCodeBlock == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(13);
        }
        return !(statement = braceCodeBlock.getCompoundStatement()).getStatements().isEmpty() && caret >= statement.getTextRange().getEndOffset();
    }

    private static boolean isAutoConversionOfBraceBlockDisabled(@NotNull PsiFile file) {
        if (file == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(14);
        }
        return !((RubyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, RubyCodeStyleSettings.class)).CONVERT_BRACE_BLOCK_BY_ENTER;
    }

    private static boolean isAutoWrapInProgress(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(15);
        }
        return DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) != null;
    }

    private static boolean isInsideAnotherCall(@NotNull RCodeBlock codeBlock) {
        if (codeBlock == null) {
            RubyBraceBlockEnterHandler.$$$reportNull$$$0(16);
        }
        RPsiElement container = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)codeBlock.getParent(), (Class[])new Class[]{RPossibleCall.class, RContainer.class});
        return container instanceof RPossibleCall;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlockClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceCodeBlock";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyBraceBlockEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeBlockAt";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEnterInBraceBlock";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "performBraceBlockConversion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaretAfterBlockCompoundStatement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutoConversionOfBraceBlockDisabled";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutoWrapInProgress";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideAnotherCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

