/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;

public class ErbSpacingProcessor
extends RubyFormattingProcessor {
    public ErbSpacingProcessor(CommonCodeStyleSettings settings) {
        super(settings);
    }

    @Nullable
    public Spacing getSpacing(@NotNull ASTNode parentNode, @Nullable ASTNode leftBlockNode, @Nullable ASTNode rightBlockNode) {
        if (parentNode == null) {
            ErbSpacingProcessor.$$$reportNull$$$0(0);
        }
        if (leftBlockNode == null || rightBlockNode == null) {
            return null;
        }
        IElementType leftBlockType = leftBlockNode.getElementType();
        IElementType rightBlockType = rightBlockNode.getElementType();
        IElementType parentNodeType = parentNode.getElementType();
        ASTNode rightBlockNodePrev = rightBlockNode.getTreePrev();
        if (parentNodeType == ErbElementTypes.ERB_XML_TAG) {
            String nodePrevText;
            PsiElement previousRubyElement;
            if (ErbTokenTypes.ERB_SEPARATORS_STARTS.contains(leftBlockType)) {
                if (leftBlockType == ErbTokenTypes.ERB_SCRIPTLET_START && rightBlockType == ErbTokenTypes.OMIT_NEW_LINE) {
                    return this.createNoSpacing();
                }
                return this.createSingleSpacing();
            }
            if (leftBlockType == ErbTokenTypes.OMIT_NEW_LINE) {
                ASTNode leftPrev;
                if (ErbTokenTypes.ERB_SEPARATORS_ENDS.contains(rightBlockType) && ((leftPrev = leftBlockNode.getTreePrev()) == null || !ErbTokenTypes.ERB_SEPARATORS_STARTS.contains(leftPrev.getElementType()))) {
                    return this.createNoSpacing();
                }
                return this.createSingleSpacing();
            }
            if (rightBlockType == ErbTokenTypes.OMIT_NEW_LINE) {
                return this.createSingleSpacing();
            }
            PsiFile psiFile = parentNode.getPsi().getContainingFile();
            FileViewProvider viewProvider = psiFile.getViewProvider();
            PsiFile rubyFile = viewProvider.getPsi((Language)RubyLanguage.INSTANCE);
            if (rubyFile != null && rightBlockNode.getStartOffset() > 0 && (previousRubyElement = rubyFile.findElementAt(rightBlockNode.getStartOffset() - 1)) instanceof PsiComment && previousRubyElement.getText().endsWith(" ")) {
                return this.createNoSpacing();
            }
            String string = nodePrevText = rightBlockNodePrev != null ? rightBlockNodePrev.getText() : "";
            if (!leftBlockNode.getText().endsWith(" ") && !nodePrevText.endsWith("\n") && ErbTokenTypes.ERB_SEPARATORS_ENDS.contains(rightBlockType)) {
                return this.createSingleSpacing();
            }
        }
        if (parentNodeType == XmlElementType.XML_ATTRIBUTE) {
            if (leftBlockType == XmlTokenType.XML_NAME || leftBlockType == XmlTokenType.XML_EQ || rightBlockType == XmlTokenType.XML_EQ || rightBlockType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                this.createNoSpacing();
            }
            if (rightBlockType == XmlTokenType.XML_NAME) {
                if (leftBlockType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                    this.createNoSpacing();
                }
                if (ErbTokenTypes.ERB_SEPARATORS_ENDS.contains(leftBlockType)) {
                    if (rightBlockNodePrev == null || !(rightBlockNodePrev.getPsi() instanceof PsiWhiteSpace)) {
                        return this.createSingleSpacing();
                    }
                    this.createNoSpacing();
                }
            }
        }
        return null;
    }

    private Spacing createNoSpacing() {
        return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing createSingleSpacing() {
        return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbSpacingProcessor", "getSpacing"));
    }
}

