/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbFileType;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;

public class ErbIndentProcessor
extends ErbFormattingProcessor {
    private final CommonCodeStyleSettings.IndentOptions myErbIndentOptions;

    public ErbIndentProcessor(XmlFormattingPolicy xmlFormattingPolicy) {
        super(xmlFormattingPolicy);
        CodeStyleSettings codeStyleSettings = xmlFormattingPolicy.getSettings();
        this.myErbIndentOptions = codeStyleSettings.getIndentOptions((FileType)ErbFileType.ERB);
    }

    @NotNull
    public Indent calcHTMLIndentForChild(@NotNull ASTNode parentNode) {
        if (parentNode == null) {
            ErbIndentProcessor.$$$reportNull$$$0(0);
        }
        Indent indent = Indent.getSpaceIndent((int)this.calcHTMLIndentSize(parentNode));
        if (indent == null) {
            ErbIndentProcessor.$$$reportNull$$$0(1);
        }
        return indent;
    }

    @NotNull
    public Indent calcErbIndentForChild(@Nullable RCompoundStatement childRCmpSt, @Nullable RCompoundStatement parentRCmpSt, @Nullable ASTNode parentNode, boolean addHtmlIndent) {
        int indent_size = 0;
        if (addHtmlIndent && parentNode != null) {
            indent_size = this.calcHTMLIndentSize(parentNode);
        }
        Indent indent = Indent.getSpaceIndent((int)(indent_size += this.calcRubyIndentSize(childRCmpSt, parentRCmpSt)));
        if (indent == null) {
            ErbIndentProcessor.$$$reportNull$$$0(2);
        }
        return indent;
    }

    public Indent calcRubyIndentForNode(@Nullable RCompoundStatement childRCmpSt, @Nullable RCompoundStatement parentRCmpSt) {
        return Indent.getSpaceIndent((int)this.calcRubyIndentSize(childRCmpSt, parentRCmpSt));
    }

    public int calcHTMLIndentSize(@NotNull ASTNode parentNode) {
        PsiElement parentPsi;
        if (parentNode == null) {
            ErbIndentProcessor.$$$reportNull$$$0(3);
        }
        if ((parentPsi = parentNode.getPsi()) instanceof XmlTag ? !this.myXmlFormattingPolicy.indentChildrenOf((XmlTag)parentPsi) : ErbFormatterUtil.isHTMLDocumentRootOrProlog(parentNode)) {
            return 0;
        }
        return this.myErbIndentOptions.INDENT_SIZE;
    }

    public int calcRubyIndentSize(@Nullable RCompoundStatement childRCmpSt, @Nullable RCompoundStatement parentRCmpSt) {
        int indent_count = 0;
        RCompoundStatement current = childRCmpSt;
        while (current != null && current != parentRCmpSt) {
            ++indent_count;
            current = RCompoundStatementNavigator.getParentCompoundStatement((PsiElement)current);
        }
        return indent_count * this.myErbIndentOptions.INDENT_SIZE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbIndentProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbIndentProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcHTMLIndentForChild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcErbIndentForChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcHTMLIndentForChild";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcHTMLIndentSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

