/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbRubyInjectionTagNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;

public final class ErbFormatterUtil {
    private ErbFormatterUtil() {
    }

    static TextRange safelyCreateTextRange(int startOffset, int endOffset) {
        return startOffset < endOffset ? new TextRange(startOffset, endOffset) : null;
    }

    public static boolean canBeCorrectBlock(@Nullable ASTNode node) {
        return node != null && !node.getText().trim().isEmpty();
    }

    @Nullable
    public static ASTNode getNodeByBlockForErbFormatter(Block child1) {
        if (child1 instanceof AbstractBlock) {
            return ((AbstractBlock)child1).getNode();
        }
        if (child1 instanceof RubyBlock) {
            return ((RubyBlock)child1).getNode();
        }
        return null;
    }

    @Nullable
    public static RCompoundStatement getParentRCmpStByErbOrHTMLChildNode(@NotNull FileViewProvider provider, @NotNull ASTNode node) {
        RCompoundStatement cmpSt;
        if (provider == null) {
            ErbFormatterUtil.$$$reportNull$$$0(0);
        }
        if (node == null) {
            ErbFormatterUtil.$$$reportNull$$$0(1);
        }
        if ((cmpSt = ErbFormatterUtil.getRCmpStNodeStartOffset(provider, node)) == null) {
            return null;
        }
        return ErbFormatterUtil.isErbXmlTagForRubyBlockEnd(node, cmpSt, provider) ? RCompoundStatementNavigator.getParentCompoundStatement((PsiElement)cmpSt) : cmpSt;
    }

    @Nullable
    public static RCompoundStatement getRCmpStNodeStartOffset(@NotNull FileViewProvider provider, @NotNull ASTNode node) {
        int boundsStart;
        PsiElement rubyPsi;
        if (provider == null) {
            ErbFormatterUtil.$$$reportNull$$$0(2);
        }
        if (node == null) {
            ErbFormatterUtil.$$$reportNull$$$0(3);
        }
        if ((rubyPsi = provider.findElementAt(boundsStart = node.getStartOffset(), (Language)RubyLanguage.INSTANCE)) == null) {
            return null;
        }
        if (rubyPsi instanceof RCompoundStatement) {
            return (RCompoundStatement)rubyPsi;
        }
        return RCompoundStatementNavigator.getByPsiElement((PsiElement)rubyPsi);
    }

    @Nullable
    public static PsiElement findUpperHTMLElement(@NotNull FileViewProvider provider, int startOffset, @Nullable TextRange boundsTRange) {
        TextRange htmlPsiRange;
        TextRange htmlParentRange;
        PsiElement htmlPsi;
        if (provider == null) {
            ErbFormatterUtil.$$$reportNull$$$0(4);
        }
        HTMLLanguage templateLanguage = HTMLLanguage.INSTANCE;
        if (provider instanceof TemplateLanguageFileViewProvider) {
            templateLanguage = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
        }
        PsiElement htmlPsiParent = (htmlPsi = provider.findElementAt(startOffset, (Language)templateLanguage)) != null ? htmlPsi.getParent() : null;
        TextRange textRange = htmlParentRange = htmlPsiParent != null ? htmlPsiParent.getTextRange() : null;
        while (!(htmlPsi instanceof XmlText || htmlPsi instanceof XmlDocument || ErbFormatterUtil.isRegisteredContainerElement(htmlPsi) || htmlParentRange == null || htmlParentRange.getStartOffset() != startOffset || boundsTRange != null && !ErbFormatterUtil.isRegisteredContainerElement(htmlPsiParent) && !boundsTRange.contains(htmlParentRange))) {
            htmlPsiParent = (htmlPsi = htmlPsi.getParent()) != null ? htmlPsi.getParent() : null;
            htmlParentRange = htmlPsiParent != null ? htmlPsiParent.getTextRange() : null;
        }
        if (htmlPsi instanceof XmlText || htmlPsi instanceof XmlDocument) {
            htmlPsi = htmlPsi.getFirstChild();
        }
        if (htmlPsi instanceof XmlProlog) {
            htmlPsi = htmlPsi.getNextSibling();
        }
        TextRange textRange2 = htmlPsiRange = htmlPsi != null ? htmlPsi.getTextRange() : null;
        if (boundsTRange != null && htmlPsiRange != null && !boundsTRange.intersectsStrict(htmlPsiRange)) {
            return null;
        }
        return htmlPsi;
    }

    public static PsiElement findErbElementByStartOffset(FileViewProvider vProvider, int startOffset, boolean searchHighest) {
        PsiElement psiElement = vProvider.findElementAt(startOffset, (Language)ErbLanguage.INSTANCE);
        if (searchHighest && psiElement != null) {
            for (PsiElement psiParent = psiElement.getParent(); psiParent != null && !(psiParent instanceof XmlDocument) && psiParent.getTextRange().getStartOffset() == startOffset; psiParent = psiParent.getParent()) {
                psiElement = psiParent;
            }
        }
        return psiElement;
    }

    public static boolean isErbXmlTagForRubyBlockEnd(@NotNull ASTNode erbTagNode, @NotNull RCompoundStatement nodeCmpSt, @NotNull FileViewProvider vProvider) {
        PsiElement cmpStEndInErb;
        if (erbTagNode == null) {
            ErbFormatterUtil.$$$reportNull$$$0(5);
        }
        if (nodeCmpSt == null) {
            ErbFormatterUtil.$$$reportNull$$$0(6);
        }
        if (vProvider == null) {
            ErbFormatterUtil.$$$reportNull$$$0(7);
        }
        if ((cmpStEndInErb = ErbFormatterUtil.findErbElementByStartOffset(vProvider, nodeCmpSt.getTextRange().getEndOffset() - 1, false)) != null) {
            ErbCodeInjectionTag injectionTag = ErbRubyInjectionTagNavigator.getByPsiElement((PsiElement)cmpStEndInErb);
            ASTNode injectionTagNode = injectionTag != null ? injectionTag.getNode() : null;
            return injectionTagNode != null && injectionTagNode.getTextRange().equals((Object)erbTagNode.getTextRange());
        }
        return false;
    }

    public static boolean isRegisteredContainerElement(PsiElement htmlPsi) {
        return ErbFormatterUtil.isTagOrAttrElementOrAttrValue(htmlPsi) || ErbFormatterUtil.isSpecialElement(htmlPsi);
    }

    public static boolean isHTMLDocumentRootOrProlog(ASTNode parentNode) {
        IElementType type = parentNode.getElementType();
        return type == XmlElementType.HTML_DOCUMENT || type == XmlElementType.XML_PROLOG || type == XmlElementType.XML_PROCESSING_INSTRUCTION;
    }

    public static boolean isTagOrAttrElementOrAttrValue(PsiElement htmlPsi) {
        return htmlPsi instanceof XmlTag || htmlPsi instanceof XmlAttribute || htmlPsi instanceof XmlAttributeValue || htmlPsi instanceof XmlDoctype || htmlPsi instanceof XmlProcessingInstruction;
    }

    public static boolean isSpecialElement(PsiElement htmlPsi) {
        return ErbFormatterUtil.isJSEmbeddedContent(htmlPsi);
    }

    public static boolean isScripletErbXmlTagNode(@NotNull ASTNode erbTagNode) {
        ASTNode firstChildNode;
        if (erbTagNode == null) {
            ErbFormatterUtil.$$$reportNull$$$0(8);
        }
        return (firstChildNode = erbTagNode.getFirstChildNode()) != null && firstChildNode.getElementType() == ErbTokenTypes.ERB_SCRIPTLET_START;
    }

    static boolean isJSEmbeddedContent(PsiElement htmlPsi) {
        return htmlPsi != null && !(htmlPsi.getLanguage() instanceof XMLLanguage) && htmlPsi.getLanguage() != Language.ANY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "erbTagNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCmpSt";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vProvider";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbFormatterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentRCmpStByErbOrHTMLChildNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRCmpStNodeStartOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpperHTMLElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isErbXmlTagForRubyBlockEnd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isScripletErbXmlTagNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class SpacesBlock
    implements Block {
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                SpacesBlock.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                SpacesBlock.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Nullable
        public Wrap getWrap() {
            return null;
        }

        @Nullable
        public Indent getIndent() {
            return null;
        }

        @Nullable
        public Alignment getAlignment() {
            return null;
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                SpacesBlock.$$$reportNull$$$0(2);
            }
            return null;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) {
                SpacesBlock.$$$reportNull$$$0(3);
            }
            return childAttributes;
        }

        public boolean isIncomplete() {
            return false;
        }

        public boolean isLeaf() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbFormatterUtil$SpacesBlock";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbFormatterUtil$SpacesBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

