/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingHelper;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public class ErbBlock
extends AbstractBlock {
    protected final ErbFormattingHelper myHelper;
    private final Indent myIndent;
    private final TextRange myTextRange;
    private final RCompoundStatement myNodeCmpSt;
    private final FileViewProvider myViewProvider;

    public ErbBlock(@NotNull ASTNode node, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull ErbFormattingHelper helper, @Nullable TextRange textRange, @Nullable Alignment alignment) {
        FileViewProvider provider;
        if (node == null) {
            ErbBlock.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            ErbBlock.$$$reportNull$$$0(1);
        }
        super(node, wrap, alignment);
        this.myIndent = indent;
        this.myHelper = helper;
        this.myTextRange = textRange == null ? node.getTextRange() : textRange;
        PsiElement nodePsi = node.getPsi();
        FileViewProvider fileViewProvider = provider = nodePsi == null ? null : nodePsi.getContainingFile().getViewProvider();
        assert (provider != null);
        this.myViewProvider = provider;
        this.myNodeCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(this.myViewProvider, this.myNode);
    }

    public ErbBlock(@NotNull ASTNode node, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull ErbFormattingHelper helper) {
        if (node == null) {
            ErbBlock.$$$reportNull$$$0(2);
        }
        if (helper == null) {
            ErbBlock.$$$reportNull$$$0(3);
        }
        this(node, indent, wrap, helper, null, null);
    }

    public ErbBlock(@NotNull ASTNode node, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull ErbFormattingHelper helper, @Nullable Alignment alignment) {
        if (node == null) {
            ErbBlock.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            ErbBlock.$$$reportNull$$$0(5);
        }
        this(node, indent, wrap, helper, null, alignment);
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            ErbBlock.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            ErbBlock.$$$reportNull$$$0(7);
        }
        if (child1 == null) {
            return null;
        }
        ASTNode childNode1 = ErbFormatterUtil.getNodeByBlockForErbFormatter(child1);
        ASTNode childNode2 = ErbFormatterUtil.getNodeByBlockForErbFormatter(child2);
        return this.myHelper.getSpacingProcessor().getSpacing(this.getNode(), childNode1, childNode2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent indent = Indent.getNoneIndent();
        List subBlocks = this.getSubBlocks();
        if (newChildIndex != 0 && newChildIndex < subBlocks.size()) {
            ASTNode curNode;
            Block currBlock = (Block)subBlocks.get(newChildIndex);
            ASTNode aSTNode = curNode = currBlock instanceof AbstractBlock ? ((AbstractBlock)currBlock).getNode() : null;
            if (curNode != null) {
                RCompoundStatement childCmpSt = ErbFormatterUtil.getRCmpStNodeStartOffset(this.myViewProvider, curNode);
                indent = this.myHelper.getIndentProcessor().calcRubyIndentForNode(childCmpSt, this.myNodeCmpSt);
            }
        }
        return new ChildAttributes(indent, null);
    }

    public boolean isIncomplete() {
        return this.isIncomplete(this.myNode);
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        ASTNode lastChild;
        if (node == null) {
            ErbBlock.$$$reportNull$$$0(8);
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getPsi() instanceof PsiErrorElement) {
            return true;
        }
        return this.isIncomplete(lastChild);
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public String toString() {
        return "Block at: " + this.myNode.toString();
    }

    @NotNull
    protected List<Block> buildChildren() {
        List<Block> list = this.myHelper.getBlockGenerator().createErbSubBlocks(this.myNode, this, this.myViewProvider);
        if (list == null) {
            ErbBlock.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbBlock";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

