/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.highlighting;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.highlighting.ErbHighlighter;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public class ErbEditorHighlighter
extends LayeredLexerEditorHighlighter {
    @Nullable
    private final Project myProject;
    @Nullable
    private final VirtualFile myFile;

    public ErbEditorHighlighter(@NotNull EditorColorsScheme scheme, @Nullable Project project, @Nullable VirtualFile file) {
        if (scheme == null) {
            ErbEditorHighlighter.$$$reportNull$$$0(0);
        }
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ErbLanguage.INSTANCE, (Project)project, (VirtualFile)file), scheme);
        this.myProject = project;
        this.myFile = file;
        SyntaxHighlighter rubyHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)RubyLanguage.INSTANCE, (Project)project, (VirtualFile)file);
        LayerDescriptor rubyLayer = new LayerDescriptor(rubyHighlighter, "\n", ErbHighlighter.ERB_SCRIPTING_BACKGROUND);
        this.registerLayer(ErbTokenTypes.RUBY_CODE_CHARACTERS, rubyLayer);
        Language templateLanguage = this.getCurrentTemplateLanguageAndPrefixes();
        SyntaxHighlighter templateLanguageHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)templateLanguage, (Project)this.myProject, (VirtualFile)this.myFile);
        this.registerLayer(ErbTokenTypes.TEMPLATE_CHARACTERS_IN_ERB, new LayerDescriptor(templateLanguageHighlighter, "", null));
    }

    @VisibleForTesting
    public Language getCurrentTemplateLanguageAndPrefixes() {
        if (this.myFile instanceof VirtualFileWindow || this.myFile == null || this.myProject == null) {
            return HTMLLanguage.INSTANCE;
        }
        return (Language)ReadAction.nonBlocking(() -> {
            if (this.myProject.isDisposed()) {
                return HTMLLanguage.INSTANCE;
            }
            FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myFile);
            if (viewProvider instanceof TemplateLanguageFileViewProvider) {
                return ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage();
            }
            return HTMLLanguage.INSTANCE;
        }).executeSynchronously();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "org/jetbrains/plugins/ruby/erb/highlighting/ErbEditorHighlighter", "<init>"));
    }
}

