/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbFileType;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.RubyErbIntegrationImplKt;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.templates.TemplateIntegration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J4\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/ruby/erb/RubyErbIntegrationImpl;", "Lorg/jetbrains/plugins/ruby/templates/TemplateIntegration;", "<init>", "()V", "canModifyPsiInsert", "", "provider", "Lcom/intellij/psi/FileViewProvider;", "addRubyStatement", "Lcom/intellij/psi/PsiElement;", "parent", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/blocks/RCompoundStatement;", "elementToAdd", "anchor", "before", "getFileTemplateName", "", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getLanguage", "Lcom/intellij/lang/Language;", "getTextForI18n", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "replaceTextWithI18n", "expression", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/expressions/RExpression;", "mustCloseRubyBlock", "intellij.ruby.common"})
final class RubyErbIntegrationImpl
implements TemplateIntegration {
    public boolean canModifyPsiInsert(@NotNull FileViewProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return false;
    }

    @Nullable
    public PsiElement addRubyStatement(@NotNull FileViewProvider provider, @NotNull RCompoundStatement parent, @NotNull PsiElement elementToAdd, @Nullable PsiElement anchor, boolean before) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)elementToAdd, (String)"elementToAdd");
        return null;
    }

    @NotNull
    public String getFileTemplateName() {
        return "ERB File";
    }

    @NotNull
    public FileType getFileType() {
        ErbFileType erbFileType = ErbFileType.ERB;
        Intrinsics.checkNotNullExpressionValue((Object)erbFileType, (String)"ERB");
        return (FileType)erbFileType;
    }

    @NotNull
    public Language getLanguage() {
        ErbLanguage erbLanguage = ErbLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)erbLanguage, (String)"INSTANCE");
        return (Language)erbLanguage;
    }

    @Nullable
    public String getTextForI18n(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement[] psiElementArray = RubyErbIntegrationImplKt.access$findTextRangeElementsAtCaret(editor, file);
        if (psiElementArray == null) {
            return null;
        }
        PsiElement[] elements = psiElementArray;
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = elements[0].getTextRange().getStartOffset();
        int n2 = elements[1].getTextRange().getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    public boolean replaceTextWithI18n(@NotNull Editor editor, @NotNull PsiFile file, @NotNull RExpression expression) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement[] psiElementArray = RubyErbIntegrationImplKt.access$findTextRangeElementsAtCaret(editor, file);
        if (psiElementArray == null) {
            return false;
        }
        PsiElement[] elements = psiElementArray;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int startOffset = elements[0].getTextRange().getStartOffset();
        int endOffset = elements[1].getTextRange().getEndOffset();
        document2.replaceString(startOffset, endOffset, (CharSequence)("<%= " + expression.getText() + " %>"));
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        return true;
    }

    public boolean mustCloseRubyBlock() {
        return true;
    }
}

