/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.codeInsight.ErbEditUtil;
import org.jetbrains.plugins.ruby.erb.psi.ErbOuterLanguageElement;
import org.jetbrains.plugins.ruby.ruby.actions.editor.handlers.RubyEnterHandlerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public final class ErbEnterHandler
implements EnterHandlerDelegate {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            ErbEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ErbEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            ErbEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            ErbEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ErbEnterHandler.$$$reportNull$$$0(4);
        }
        if (!file.getViewProvider().getLanguages().contains(ErbLanguage.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (file.getLanguage().equals(RubyLanguage.INSTANCE)) {
            PsiElement psiElement = file.getViewProvider().findElementAt((Integer)caretOffset.get() - 1, (Language)ErbLanguage.INSTANCE);
            if (!(psiElement instanceof ErbOuterLanguageElement)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            ErbOuterLanguageElement erbElement = (ErbOuterLanguageElement)psiElement;
            int offsetInErbElement = (Integer)caretOffset.get() - erbElement.getTextOffset();
            String suffix = erbElement.getText().substring(offsetInErbElement);
            if (!suffix.isBlank() && !ErbEditUtil.isInsideMultilineErbTag(file.getViewProvider(), (Integer)caretOffset.get() - 1)) {
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        caretOffset.set((Object)ErbEnterHandler.closeStructureWithEnd(file, editor, (Integer)caretOffset.get()));
        return EnterHandlerDelegate.Result.Continue;
    }

    private static int closeStructureWithEnd(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        if (file == null) {
            ErbEnterHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ErbEnterHandler.$$$reportNull$$$0(6);
        }
        if (!CodeInsightSettings.getInstance().SMART_END_ACTION) {
            return caretOffset;
        }
        PsiElement element = file.findElementAt(caretOffset - 1);
        if (element == null) {
            return caretOffset;
        }
        ASTNode elementNode = element.getNode();
        IElementType type = elementNode.getElementType();
        Document document = editor.getDocument();
        RFile rFile = (RFile)file.getViewProvider().getPsi((Language)RubyLanguage.INSTANCE);
        if (!TokenBNF.tSTRING_LIKE_CONTENTS.contains(type) && !TokenBNF.tDOT_OR_COLON.contains(type) && rFile != null && RubyEnterHandlerUtil.isEndNeeded((Editor)editor, (PsiFile)rFile, (int)caretOffset)) {
            CaretModel caretModel;
            int currentOffset;
            int lineEndOffset = document.getLineEndOffset(document.getLineNumber(caretOffset));
            if (lineEndOffset != (currentOffset = (caretModel = editor.getCaretModel()).getOffset())) {
                caretModel.moveToOffset(lineEndOffset);
            }
            String endString = ErbEditUtil.isInsideMultilineErbTag(file.getViewProvider(), caretOffset - 1) ? "\nend" : "\n<% end %>";
            document.insertString(lineEndOffset, (CharSequence)endString);
            CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent(document, lineEndOffset + 1);
            return lineEndOffset;
        }
        return caretOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/erb/ErbEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "closeStructureWithEnd";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

