/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl.remote.ruby;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.wsl.remote.ruby.RubyWslBundle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;

public final class RubyWslUtil {
    public static final Logger LOG = Logger.getInstance(RubyWslUtil.class);

    private RubyWslUtil() {
    }

    @NotNull
    public static ProcessOutput executeHelperScript(@NotNull WSLDistribution distro, @Nullable Consumer<? super ProcessHandler> processConsumer, int timeoutMs, @NotNull String scriptRelativePath, String ... scriptArgs) throws ExecutionException {
        String scriptPath;
        if (distro == null) {
            RubyWslUtil.$$$reportNull$$$0(0);
        }
        if (scriptRelativePath == null) {
            RubyWslUtil.$$$reportNull$$$0(1);
        }
        if ((scriptPath = RubyUtil.getScriptFullPath((String)scriptRelativePath)) == null) {
            throw new ExecutionException(RubyWslBundle.message("error.fail.locate.helper.script", scriptRelativePath));
        }
        String scriptWslPath = RubyWslUtil.toWslPath(distro, Path.of(scriptPath, new String[0]));
        List command = ContainerUtil.append(List.of("sh", "--", scriptWslPath), (Object[])((String[])ObjectUtils.coalesce((Object)scriptArgs, (Object)ArrayUtil.EMPTY_STRING_ARRAY)));
        ProcessOutput output = distro.executeOnWsl(command, new WSLCommandLineOptions(), timeoutMs, processConsumer);
        if (output.getExitCode() != 0 || output.isTimeout() || output.isCancelled()) {
            LOG.debug("Failed to execute helper wsl script: ", new Object[]{scriptWslPath, ", output=", output});
            throw new ExecutionException(RubyWslBundle.message("error.fail.execute.helper.script", scriptWslPath, output.getExitCode(), output.getStderr(), output.getStdout()));
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            RubyWslUtil.$$$reportNull$$$0(2);
        }
        return processOutput;
    }

    @NotNull
    public static String createTempFile(@NotNull WSLDistribution distro, @NotNull String content, @NotNull String prefix, @Nullable String suffix) throws IOException, ExecutionException {
        if (distro == null) {
            RubyWslUtil.$$$reportNull$$$0(3);
        }
        if (content == null) {
            RubyWslUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            RubyWslUtil.$$$reportNull$$$0(5);
        }
        File tmpFile = FileUtil.createTempFile((String)prefix, (String)suffix);
        FileUtil.writeToFile((File)tmpFile, (String)content);
        return RubyWslUtil.toWslPath(distro, tmpFile.toPath());
    }

    @NotNull
    private static String toWslPath(@NotNull WSLDistribution distro, @NotNull Path winPath) throws ExecutionException {
        String wslPath;
        if (distro == null) {
            RubyWslUtil.$$$reportNull$$$0(6);
        }
        if (winPath == null) {
            RubyWslUtil.$$$reportNull$$$0(7);
        }
        if ((wslPath = distro.getWslPath(winPath)) == null) {
            throw new ExecutionException(RubyWslBundle.message("error.fail.path.convert.win.to.wsl", winPath));
        }
        String string = wslPath;
        if (string == null) {
            RubyWslUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRelativePath";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/remote/ruby/RubyWslUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "winPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/remote/ruby/RubyWslUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeHelperScript";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toWslPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeHelperScript";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toWslPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8 -> new IllegalStateException(string);
        };
    }
}

